/*****************************************************************/
/* Dateiname   : ClientConnectVariabel.c                         */
/* Beschreibung: Client-Programm                                 */
/*               baut eine TCP-Verbindung zu einem Server auf.   */
/*               IP-Adresse und Port-Nummer sind Kommandozeilen- */
/*               parameter und damit variabel                    */
/*****************************************************************/
#include <stdlib.h>
#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int anzahl, char *argumente[])
  {
   int socket_nummer;
   int laenge;
   int ergebnis;
   unsigned short int portnummer;
   struct sockaddr_in adressinfo;
   char *ip_adresse;

   if (anzahl != 3)
     {
      printf("\n Falsche Anzahl von Parametern !");
      printf("\n Bitte IP-Adresse und Portnummer angeben.");
      printf("\n Beispiel:");
      printf("\n\n          ClientConnectVariabel 127.0.0.1 80");
      printf("\n\n verbindet mit Port 80 und IP-Adresse 127.0.0.1");
     }
   else
     {
      ip_adresse = argumente[1];
      portnummer = atoi(argumente[2]);

      printf("\n Ziel = %s Port %u",ip_adresse, portnummer);      

      socket_nummer = socket(AF_INET, SOCK_STREAM, 0);
      adressinfo.sin_family = AF_INET;
      inet_pton(AF_INET,ip_adresse,&adressinfo.sin_addr.s_addr);
      adressinfo.sin_port = htons(portnummer);
      laenge = sizeof(adressinfo);
      ergebnis = connect(socket_nummer, (struct sockaddr *)&adressinfo, laenge);
      if (ergebnis == 0)
        {
         printf("\n\n Verbindungsaufbau erfolgreich");
        }
      else
        {
         perror(" Fehler beim Verbindungsaufbau");
        }
      close(socket_nummer);
     }
   printf("\n\n");
   return(0);
  }




