/*****************************************************************/
/* Dateiname   : ClientDateiSpeichern.c                          */
/* Beschreibung: Client-Programm                                 */
/*               fordert eine Datei vom Server an                */
/*               prft die Ergebnismeldung des Servers           */
/*               speichert die Datei auf dem Client-Rechner      */
/*****************************************************************/
#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>

int main()
{
 int socket_nummer;
 int laenge;
 int ergebnis;
 int anzahl;
 struct sockaddr_in adresse;
 char dateiname[] = "empfangen.txt";
 char empfangene_zeichen[65000];
 FILE *datei;

 unsigned short int portnummer = 80;
 char ip_adresse[] = "127.0.0.1";
 char befehl[] = "GET /hallo.txt HTTP/1.1\r\nHost: PC\r\n\r\n";

 socket_nummer = socket(AF_INET, SOCK_STREAM, 0);
 
 adresse.sin_family = AF_INET;
 inet_pton(AF_INET,ip_adresse,&adresse.sin_addr.s_addr);
 adresse.sin_port = htons(portnummer);
 laenge = sizeof(adresse);
 
 ergebnis = connect(socket_nummer, (struct sockaddr *)&adresse, laenge);
 
 printf("\n Verbindung zu IP %s",ip_adresse);
 printf(" an Port %d",portnummer);

 if (ergebnis == -1)
   {
    perror(" Keine Verbindung erfolgt: ");
   }
 else
   {
    printf("\n Verbindung erfolgt");
    printf(", sende HTTP-Befehl:\n\n%s",befehl);

    anzahl = write(socket_nummer, befehl, sizeof(befehl));
    printf(" es wurden %d Zeichen gesendet",anzahl);
 
    anzahl = read(socket_nummer, empfangene_zeichen, 
                  sizeof(empfangene_zeichen));
    empfangene_zeichen[anzahl]= '\0';
    
    printf("\n es wurden %d Zeichen empfangen:",anzahl);
    printf("\n\n%s",empfangene_zeichen);
    
    if (strstr(empfangene_zeichen,"200 OK") == NULL)
      {
       printf("\n Der Server hat die Datei nicht gesendet");
      }
    else
      {
       printf("\n Der Server hat die Datei gesendet");
       
       datei = fopen(dateiname,"wt");

       if (datei==NULL)
         {
          printf("\n Die Datei %s ",dateiname);
          printf("konnte nicht geffnet werden");
         }
       else
         {
          printf("\n Empfangene Daten werden ");
          printf("in %s gespeichert",dateiname);
          fprintf(datei,"%s",empfangene_zeichen);
          fclose(datei);
         }
      }    
   }  
   
 close(socket_nummer);  

 printf("\n Programm beendet\n\n");
 return(0);
}

