/*****************************************************************/
/* Dateiname   : ServerAccept.c                                  */
/* Beschreibung: Server-Programm                                 */
/*               akzeptiert eine TCP-Verbindung an Port 5000     */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>

int main()
{
 int server_socket, neuer_socket;
 int laenge;
 struct sockaddr_in serverinfo, clientinfo;

 unsigned short int portnummer = 5000;
 char server_ip[] = "127.0.0.1";
 char client_ip[INET_ADDRSTRLEN];

 printf("\n Server: socket()...");

 server_socket = socket(AF_INET, SOCK_STREAM, 0);
 
 serverinfo.sin_family = AF_INET;
 inet_pton(AF_INET,server_ip,&serverinfo.sin_addr.s_addr);
 serverinfo.sin_port = htons(portnummer);
 laenge = sizeof(serverinfo);

 printf("\n Server: bind()...");
 
 bind(server_socket, (struct sockaddr *)&serverinfo, laenge);

 printf("\n Server: listen()...");
 printf("\n Server mit IP %s",server_ip);
 printf(" an Port %d wartet...",portnummer);

 listen(server_socket, 3);

 printf("\n Server: accept()...");
 
 neuer_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);
 
 inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
 printf("Verbindung mit %s",client_ip);

 printf("\n Server: close()...");
   
 close(server_socket);
 close(neuer_socket);
   
 printf("\n Serverprogramm beendet\n\n");
 return(0);
}



