/*****************************************************************/
/* Dateiname   : ServerDateiOeffnen.c                            */
/* Beschreibung: Server-Programm                                 */
/*               Analysiert einen HTTP-GET-Befehl und versucht   */
/*               die angeforderte Datei zu ffnen                */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

int main()
  {
   int server_socket, client_socket;
   int anzahl, laenge;
   struct sockaddr_in serverinfo, clientinfo;
   char client_ip[INET_ADDRSTRLEN];
   char empfangen[1000];
   char *position1, *position2;
   char dateiname[100];
   char text_http_ok[] = "HTTP/1.0 200 OK\r\n\r\n";
   char text_html_anfang[] = "<HTML><BODY>";
   char text_html_ende[] = "</BODY></HTML>";
   char text_dateiname[] = "Dateiname = ";
   char text_kein_GET[] = "kein GET-Befehl gefunden";
   char text_kein_HTTP[] = "kein HTTP-Befehl gefunden";
   char text_datei_existiert[] = "<br>Datei existiert";
   char text_keine_datei[] = "<br>Datei existiert nicht";
   FILE *datei;

   server_socket = socket(AF_INET, SOCK_STREAM, 0);

   serverinfo.sin_family = AF_INET;
   serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
   serverinfo.sin_port = htons(5000);
   laenge = sizeof(serverinfo);

   bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
   listen(server_socket, 3);

   while (1)
    {
     printf("\n Der Server wartet...");
     fflush(stdout);

     client_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

     inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
     printf("\n\nVerbindung mit %s",client_ip);

     anzahl = read(client_socket,empfangen,sizeof(empfangen));
     empfangen[anzahl]=0;
     write(client_socket,text_http_ok,strlen(text_http_ok));
     write(client_socket,text_html_anfang,strlen(text_html_anfang));
     if (position1 = strstr(empfangen,"GET"))
      {
       if (position2 = strstr(empfangen,"HTTP"))
        {
         laenge = position2 - position1 - 6;
         strncpy(dateiname,position1+5,laenge);
         dateiname[laenge]=0;
         printf("\n GET Befehl fr Datei %s gefunden",dateiname);
         write(client_socket,text_dateiname,strlen(text_dateiname));
         write(client_socket,dateiname,laenge);
         datei = fopen(dateiname,"rt");
	      if (datei==NULL)
	       {
	        printf("\n Datei %s existiert nicht",dateiname);
           write(client_socket,text_keine_datei,strlen(text_keine_datei));
	       }
	      else  
	       {
	        printf("\n Datei %s existiert",dateiname);
           write(client_socket,text_datei_existiert,strlen(text_datei_existiert));
           fclose(datei);
	       }
        }
       else
        {
         printf("\nDer HTTP-Parser hat keinen HTTP-Befehl gefunden");
         write(client_socket,text_kein_HTTP,strlen(text_kein_HTTP));
        }
      }
     else
      {
       printf("\nDer HTTP-Parser hat keinen GET-Befehl gefunden");
       write(client_socket,text_kein_GET,strlen(text_kein_GET));
      }
     printf("\n");
     write(client_socket,text_html_ende,strlen(text_html_ende));
     close(client_socket);
    }
  }





