/*****************************************************************/
/* Dateiname   : ServerDateiSenden.c                             */
/* Beschreibung: Server-Programm                                 */
/*               Analysiert einen HTTP-GET-Befehl und versucht   */
/*               die angeforderte Datei zu senden                */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>

int main()
 {
  int server_socket, client_socket;
  int anzahl, laenge;
  struct sockaddr_in serverinfo, clientinfo;
  char zeichen;
  char client_ip[INET_ADDRSTRLEN];
  char empfangen[1000];
  char *position1, *position2;
  char dateiname[100];
  char text_http_ok[] = "HTTP/1.0 200 OK\r\n\r\n";
  char text_html_anfang[] = "<HTML><BODY>";
  char text_html_ende[] = "</BODY></HTML>";
  FILE *datei;

  server_socket = socket(AF_INET, SOCK_STREAM, 0);

  serverinfo.sin_family = AF_INET;
  serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
  serverinfo.sin_port = htons(5000);
  laenge = sizeof(serverinfo);

  bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
  listen(server_socket, 3);

  while (1)
   {
    printf("\n Der Server wartet...");
    fflush(stdout);

    client_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

    inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
    printf("\n\nVerbindung mit %s",client_ip);

    anzahl = read(client_socket,empfangen,sizeof(empfangen));
    empfangen[anzahl]=0;
    write(client_socket,text_http_ok,strlen(text_http_ok));

    if (position1 = strstr(empfangen,"GET"))
     {
      if (position2 = strstr(empfangen,"HTTP"))
       {
        laenge = position2 - position1 - 6;
        strncpy(dateiname,position1+5,laenge);
        dateiname[laenge]=0;
        printf("\n GET Befehl fr Datei %s gefunden",dateiname);
        datei = fopen(dateiname,"rt");
        if (datei==NULL)
	      {
	       printf("\n Datei existiert nicht");
          write(client_socket,text_html_anfang,strlen(text_html_anfang));
          write(client_socket,"<br>Datei existiert nicht",25);
          write(client_socket,text_html_ende,strlen(text_html_ende));
  	      }
	     else  
	      {
	       printf("\n Sende Datei %s",dateiname);

          do
	        {
	         zeichen = fgetc(datei);
	         if (!feof(datei))
	          {
	           write(client_socket,&zeichen,1);
	          }	
	        } while (!feof(datei));

          fclose(datei);
         }
       }
      else
       {
        printf("\n Der HTTP-Parser hat keinen HTTP-Befehl gefunden");
        write(client_socket,text_html_anfang,strlen(text_html_anfang));
        write(client_socket,"kein HTTP-Befehl gefunden",25);
        write(client_socket,text_html_ende,strlen(text_html_ende));
       }
     }
    else
     {
      printf("\n Der HTTP-Parser hat keinen GET-Befehl gefunden");
      write(client_socket,text_html_anfang,strlen(text_html_anfang));
      write(client_socket,"kein GET-Befehl gefunden",24);
      write(client_socket,text_html_ende,strlen(text_html_ende));
    }
    printf("\n");
    close(client_socket);
   }
 }





