/*****************************************************************/
/* Dateiname   : ServerGrafikSenden.c                            */
/* Beschreibung: Server-Programm                                 */
/*               Analysiert einen HTTP-GET-Befehl und versucht   */
/*               eine Grafik-Datei oder eine HTML-Datei zu senden*/
/*               nutzt die sendfile() Funktion                   */
/*****************************************************************/

#include <sys/socket.h>
#include <sys/sendfile.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

int main()
 {
  int server_socket, client_socket;
  int anzahl, laenge, dateigroesse;
  int grafikdatei;
  int dateioffset;
  struct stat dateieigenschaften;
  struct sockaddr_in serverinfo, clientinfo;
  char client_ip[INET_ADDRSTRLEN];
  char empfangen[1000];
  char senden[1000];
  char *position1, *position2;
  char dateiname[100];
  char text_http_ok[] = "HTTP/1.0 200 OK\r\n";
  char text_http_fehler[] ="HTTP/1.1 501 Not Implemented\r\n\r\n";
  char text_http_range[] = "Accept-Ranges: bytes\r\n";
  char text_http_length[] = "Content-Length: ";
  char text_dateigroesse[20];
  char text_http_typ_png[] = "Content-Type: image/png\r\n";
  char text_http_typ_html[] = "Content-Type: text/html\r\n";
  char text_leerzeile[] = "\r\n";
  char text_html_anfang[] = "<HTML><BODY>";
  char text_html_ende[] = "</BODY></HTML>";

  server_socket = socket(AF_INET, SOCK_STREAM, 0);

  serverinfo.sin_family = AF_INET;
  serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
  serverinfo.sin_port = htons(5000);
  laenge = sizeof(serverinfo);

  bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
  listen(server_socket, 3);

  while (1)
   {
    printf("\n Der Server wartet...");
    fflush(stdout);

    client_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

    inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
    printf("\n\nVerbindung mit %s",client_ip);

    anzahl = read(client_socket,empfangen,sizeof(empfangen));
    empfangen[anzahl]=0;
 
    if (position1 = strstr(empfangen,"GET"))
     {
      if (position2 = strstr(empfangen,"HTTP"))
       {
        laenge = position2 - position1 - 6;
        strncpy(dateiname,position1+5,laenge);
        dateiname[laenge]=0;
        printf("\n GET Befehl fuer Datei %s gefunden",dateiname);

        grafikdatei = open(dateiname, O_RDONLY);

        if (grafikdatei==-1)
	       {
	        printf("\n Datei existiert nicht\n");

          strcpy(senden,text_http_ok);
          strcat(senden,text_html_anfang);
          strcat(senden,"<br>Datei existiert nicht");
          strcat(senden,text_html_ende);
 
          write(client_socket,senden,strlen(senden));
	       }
	     else  
	       {
          fstat(grafikdatei,&dateieigenschaften); /*Dateigroesse bestimmen*/ 
          dateigroesse = dateieigenschaften.st_size;

          printf("\n Dateigre = %d Bytes",dateigroesse);
          sprintf(text_dateigroesse,"%d\r\n",dateigroesse);

          strcpy(senden,text_http_ok);
          strcat(senden,text_http_range);
          strcat(senden,text_http_length);
          strcat(senden,text_dateigroesse);

          if (strstr(dateiname,".png"))
           {
            strcat(senden,text_http_typ_png);
           }
          else
           {
            strcat(senden,text_http_typ_html);
           }

          strcat(senden,text_leerzeile);

          printf("\n Server: sende Paketkopf:\n%s",senden);
          write(client_socket,senden,strlen(senden));

          printf(" Server: sende Datei: %s\n",dateiname);
 
          dateioffset = 0;
          sendfile(client_socket, grafikdatei, (off_t *)&dateioffset, (size_t)dateigroesse);
          printf(" Gesendet wurden %d Zeichen\n", dateioffset);
          close(grafikdatei);
	 }
       }
      else
       {
        printf("\nDer HTTP-Parser hat keinen HTTP-Befehl gefunden");
        write(client_socket,text_http_fehler,strlen(text_http_fehler));
       }
     }
    else
     {
      printf("\nDer HTTP-Parser hat keinen GET-Befehl gefunden");
      write(client_socket,text_http_fehler,strlen(text_http_fehler));
     }
    close(client_socket);
   }
 }










