/*****************************************************************/
/* Dateiname   : ServerHTTPAnalyse.c                             */
/* Beschreibung: Server-Programm                                 */
/*               Analysiert einen empfangenen HTTP-Befehl und    */
/*               sucht nach dem GET-Kommando (Parser)            */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>

int main()
  {
   int server_socket, neuer_socket;
   int anzahl, laenge;
   struct sockaddr_in serverinfo, clientinfo;
   char client_ip[INET_ADDRSTRLEN];
   char empfangen[1000];
   char web_seite[]="HTTP/1.1 200 OK\r\n\r\n";
   char *position;
   server_socket = socket(AF_INET, SOCK_STREAM, 0);

   serverinfo.sin_family = AF_INET;
   serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
   serverinfo.sin_port = htons(5000);
   laenge = sizeof(serverinfo);

   bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
   listen(server_socket, 3);

   while(1)
     {
      printf("\n Der Server wartet...");
      fflush(stdout);

      neuer_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

      inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
      printf("\n\nVerbindung mit %s",client_ip);

      anzahl = read(neuer_socket,empfangen,sizeof(empfangen));
      empfangen[anzahl]=0;
      printf("\n\n Empfangen: \n\n%s",empfangen);

/* Anfang des HTTP-Parsers */

      if (position = strstr(empfangen,"GET"))
       {
        printf("GET-Befehl beginnt bei Zeichen %d\n\n",(position-empfangen)+1);
       }
      else
       {
        printf("Der HTTP-Parser hat keinen GET-Befehl gefunden\n\n");
       }

/* Ende des HTTP-Parsers */

      write(neuer_socket,web_seite,sizeof(web_seite));
      close(neuer_socket);
     }
  }


