/*****************************************************************/
/* Dateiname   : ServerHTTPAnzeige.c                             */
/* Beschreibung: Server-Programm                                 */
/*               Analysiert einen empfangenen HTTP-Befehl und    */
/*               extrahiert einen Dateinamen (Parser)            */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>

int main()
 {
  int server_socket, neuer_socket;
  int anzahl, laenge;
  struct sockaddr_in serverinfo, clientinfo;
  char client_ip[INET_ADDRSTRLEN];
  char empfangen[1000];
  char web_seite[] = "HTTP/1.1 200 OK\r\n\r\n";
  char *position1, *position2;
  char dateiname[100];
  server_socket = socket(AF_INET, SOCK_STREAM, 0);

  serverinfo.sin_family = AF_INET;
  serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
  serverinfo.sin_port = htons(5000);
  laenge = sizeof(serverinfo);

  bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
  listen(server_socket, 3);

  while(1)
   {
    printf("\n Der Server wartet...");
    fflush(stdout);

    neuer_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

    inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
    printf("\n\nVerbindung mit %s",client_ip);

    anzahl = read(neuer_socket,empfangen,sizeof(empfangen));
    empfangen[anzahl]=0;
    printf("\n\n Empfangen: \n\n%s",empfangen);

/* Anfang des HTTP-Parsers */

    if (position1 = strstr(empfangen,"GET"))
     {
      printf("\nGET-Befehl beginnt bei Zeichen %d",(position1-empfangen)+1);
      if (position2 = strstr(empfangen,"HTTP"))
       {
        printf("\nHTTP-Marke beginnt bei Zeichen %d",(position2-empfangen)+1);
        laenge = position2 - position1 - 6;
        strncpy(dateiname,position1+5,laenge);
        dateiname[laenge]=0;
        printf("\nLaenge = %d",laenge);
        printf("\nDateiname = %s",dateiname);
       }
      else
       {
        printf("\nDer HTTP-Parser hat keinen HTTP-Befehl gefunden");
       }
     }
    else
     {
      printf("\nDer HTTP-Parser hat keinen GET-Befehl gefunden");
     }
    printf("\n\n");

/* Ende des HTTP-Parsers */

    write(neuer_socket,web_seite,sizeof(web_seite));
    close(neuer_socket);
   }
 }



