/*****************************************************************/
/* Dateiname   : ServerHTTPPost.c                                */
/* Beschreibung: Server-Programm                                 */
/*               Sendet ein HTML-Formular und analysiert die vom */
/*               Browser per POST gesendeten Daten (Parser)      */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>

int main()
 {
  int server_socket, neuer_socket;
  int anzahl, laenge;
  struct sockaddr_in serverinfo, clientinfo;
  char client_ip[INET_ADDRSTRLEN];
  char empfangen[1000];
  char senden[1000];
  char *position;

  char HTTPok[] = "HTTP/1.1 200 OK\r\n\r\n";

  char HTTPNotImplemented[] ="HTTP/1.1 501 Not Implemented\r\n\r\n";

  char HTMLFormular[] = "\
     <HTML>\n\
       <BODY><center>\n\
         <FORM ACTION=\"ServerHTTPPost\" METHOD=\"post\">\n\
         Bitte Text eingeben und abschicken:\n\
         <br>\n\
         <INPUT TYPE=\"text\" NAME=\"eingabe\">\n\
         <br>\n\
         <INPUT TYPE=\"submit\" VALUE=\"abschicken\">\n\
         </FORM></center>\n\
        </BODY>\n\
      </HTML>\n";

  char HTMLAnfang[] = "\
    <HTML>\n\
      <BODY>\n\
        <center><h1> Ihre Eingabe: ";

  char HTMLEnde[] = "\
        </h1></center>\n\
      </BODY>\n\
    </HTML>";

  server_socket = socket(AF_INET, SOCK_STREAM, 0);

  serverinfo.sin_family = AF_INET;
  serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
  serverinfo.sin_port = htons(5000);
  laenge = sizeof(serverinfo);

  bind(server_socket, (struct sockaddr *)&serverinfo, laenge);
  listen(server_socket, 3);

  while(1)
   {
    printf("\n Der Server wartet...");
    fflush(stdout);

    neuer_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);

    inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
    printf("\n\nVerbindung mit %s",client_ip);

    anzahl = read(neuer_socket,empfangen,sizeof(empfangen));
    empfangen[anzahl]=0;
    while (strstr(empfangen,"\r\n\r\n")==NULL)
      {
       printf("\n Befehl unvollstndig, lese noch einmal...");
       anzahl = anzahl + read(neuer_socket,&empfangen[anzahl],
                sizeof(empfangen) - anzahl);
       empfangen[anzahl]=0;
      }

/* Anfang des HTTP-Parsers */

    if (strstr(empfangen,"GET") != NULL)
     {
      printf("\n\nDer HTTP-Parser hat einen GET-Befehl gefunden");

      printf("\n\n Empfangen: \n\n%s",empfangen);

      strcpy(senden,HTTPok);
      strcat(senden,HTMLFormular);

      printf("\n\n Sende: \n\n%s",senden);
      write(neuer_socket,senden,strlen(senden));
     }
    else if (strstr(empfangen,"POST") != NULL)
     {
      printf("\n\nDer HTTP-Parser hat einen POST-Befehl gefunden");
 
      position = strstr(empfangen,"eingabe");
      while (position==NULL)
        {
         printf("\n Befehl unvollstndig, lese noch einmal...");
         anzahl = anzahl + read(neuer_socket,&empfangen[anzahl],
                  sizeof(empfangen) - anzahl);
         empfangen[anzahl]=0;
         position = strstr(empfangen,"eingabe");
        }

      printf("\n\n Empfangen: \n\n%s",empfangen);

      position = position + 8;
      printf("\n\n Eingabe in das Formular = %s",position);

      strcpy(senden,HTTPok);
      strcat(senden,HTMLAnfang);
      strcat(senden,position);
      strcat(senden,HTMLEnde);

      printf("\n\n Sende: \n\n%s",senden);
      write(neuer_socket,senden,strlen(senden));
     }
    else
     {
      printf("\nDer HTTP-Parser hat keinen bekannten Befehl gefunden");

      printf("\n\n Sende: \n\n%s",HTTPNotImplemented);
      write(neuer_socket,HTTPNotImplemented,sizeof(HTTPNotImplemented));
     }
    printf("\n\n");

/* Ende des HTTP-Parsers */

    close(neuer_socket);
   }
 }





