/*****************************************************************/
/* Dateiname   : ServerHalloWelt.c                               */
/* Beschreibung: Server-Programm                                 */
/*               Sendet "Hallo Welt" Web-Seite ber Port 5000    */
/*               mit Endlos-Schleife fr beliebig viele Zugriffe */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>

int main()
{
 int server_socket, neuer_socket;
 int laenge, anzahl;
 struct sockaddr_in serverinfo, clientinfo;
 char empfangene_zeichen[1000];

char web_seite[] = "HTTP/1.1 200 OK\r\n\r\n\
<html><body><h1>Hallo Web-Welt</h1></body></html>";

 unsigned short int portnummer = 5000;
 char server_ip[] = "INADDR_ANY";
 char client_ip[INET_ADDRSTRLEN];

 printf("\n Server: socket()...");

 server_socket = socket(AF_INET, SOCK_STREAM, 0);
 
 serverinfo.sin_family = AF_INET;
 serverinfo.sin_addr.s_addr = htonl(INADDR_ANY);
 
 serverinfo.sin_port = htons(portnummer);
 laenge = sizeof(serverinfo);

 printf("\n Server: bind()...");
 
 bind(server_socket, (struct sockaddr *)&serverinfo, laenge);

 printf("\n Server: listen()...");
 printf("\n Server mit IP %s",server_ip);
 printf(" an Port %d wartet...",portnummer);

 listen(server_socket, 3);

 while(1)
   {

    printf("\n Server: accept()...");
 
    neuer_socket = accept(server_socket, (struct sockaddr *)&clientinfo, &laenge);
 
    inet_ntop(AF_INET, &clientinfo.sin_addr.s_addr, client_ip, INET_ADDRSTRLEN);
    printf("Verbindung mit %s",client_ip);

    anzahl = read(neuer_socket,empfangene_zeichen,
                  sizeof(empfangene_zeichen));

    empfangene_zeichen[anzahl]=0;

    printf("\n\n Server: empfangen: \n\n%s",empfangene_zeichen);
 
    printf("\n\n Server: sende: \n\n%s",web_seite);

    write(neuer_socket,web_seite,sizeof(web_seite));

    printf("\n\n Server: close()...");
   
    close(neuer_socket);
  } 
}


