/*
 * ICounter.h 
 */
#ifndef ICOUNTER_H
#define ICOUNTER_H

/**
 * Schnittsteller fuer Zaehlerklassen.
 */
class ICounter{
public:

    /**
     * Erhoeht den Zaehler um 1.
     */
    virtual void increment() = 0;
	
    /**
     * Gibt den aktuellen Zaehlerstand zurueck.
     * 
     * @return aktueller Zaehlerstand,
     */
    virtual int getCount() const = 0;

    /**
     * Virtueller Destruktor,
     * Der Default bewirkt nichts.
     */
    virtual ~ICounter() {}
};

#endif // ICOUNTER_H
