/*
 * Runner.cpp
 */
#include "Runner.h"
#include <time.h>
#include <iostream>

using namespace std;

Runner::Runner(ICounter* cntr, int cnt) {
    counter = cntr;
    loopCount = cnt;
}

void* Runner::run() {
    long startT = clock();
    for (int i = 0; i < loopCount; i++) {
        counter->increment();
    }
    long endT = clock();
    runTime = (double) (endT - startT) / CLOCKS_PER_SEC;
    return 0;
}

double Runner::getTime() const {
    return runTime;
}

void* run(void* r) {
    Runner* runner = (Runner*) r;
    return runner->run();
}

	
