/*
 * main.cpp
 */
 
#include "SimpleCounter.h"
#include "MutexCounter.h"
#include "Runner.h"

#include <pthread.h>
#include <string>
#include <iostream>

#define COUNT 100000000

using namespace std;

/**
 * Fuehrt einen einzelnen Test aus.
 * 
 * @param msg Titel fuer diesen Test.
 * @param c zu verwendendes Zaehlerobjekt.
 */
static void performCounterTest(const string& msg, ICounter* c);

/**
 * Fuehrt der Reihe nach verschiedene Realisierungen eines von mehreren Threads
 * genutzten Zaehlers aus.
 */
int main() {
    performCounterTest("SimpleCounter", new SimpleCounter());
    performCounterTest("MutexCounter", new MutexCounter());

    pthread_exit(0);

    return 0;
}

void performCounterTest(const string& msg, ICounter* c) {
    Runner r1(c, COUNT);
    Runner r2(c, COUNT);

    pthread_t t1, t2;
    pthread_create(&t1, NULL, run, &r1);
    pthread_create(&t2, NULL, run, &r2);	
    pthread_join(t1, NULL);
    pthread_join(t2, NULL);

    cout << msg << endl;
    cout << "Zeit: " << r1.getTime() + r2.getTime() << "s" << endl;
    cout << "Anzahl (" << 2*COUNT << "): " <<  c->getCount() << endl;
    cout << endl;
    delete c;;
}
