/*
 * AtomicCounter.java
 */

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Threadsicherer Zaehler.
 * Basiert auf den atomaren Datentyp-Implementierungen von
 * Java 5. Ist in der Regel erheblich effizienter als die
 * Nutzung von synchronized, da hier spezielle atomare Maschinenbefehle
 * des Prozessors genutzt werden.
 */
public class AtomicCounter implements ICounter {
    private AtomicInteger counter = new AtomicInteger(0);

    public void increment() {
        counter.incrementAndGet();
    }
    
    public int getCount() {
        return counter.get();
    }
}
