/*
 * Main.java
 */

/**
 * Einfaches Testprogramm fuer unterschiedliche Methoden zum Schutz
 * kritischer Abschnitte.
 */
public class Main {
	private static final int LOOPS = 10000000;

	public static void main(String[] args) {
        performCounterTest(new NaiveCounter());
        performCounterTest(new SynchronizedCounter());
        performCounterTest(new BlockSynchronizedCounter());
        performCounterTest(new LockedCounter());
        performCounterTest(new ReadWriteLockCounter());
        performCounterTest(new SemaphoreCounter()); 
        performCounterTest(new AtomicCounter());
	}

    /**
     * Fuehrt den Test eines Zaehlerobjekts durch.
     * 
     * @param cntr Zaehlerobjekt.
     */
    private static void performCounterTest(ICounter cntr) {
        try {
            System.err.println("testing: " + cntr.getClass().getName());
            // erzeuge 2 Runner-Objekte
            Runner r1 = new Runner(cntr, LOOPS);
            Runner r2 = new Runner(cntr, LOOPS);
            // erzeuge und starte 2 Threads
            Thread t1 = new Thread(r1, "runner-1");
            Thread t2 = new Thread(r2, "runner-2");
            long startTime = System.currentTimeMillis();
            t1.start();
            t2.start();			
            // warte bis beide Threads fertig sind.
            t1.join();
            t2.join();
            long endTime = System.currentTimeMillis();
            // gib die Ergebnisse aus.
            System.err.printf(
            		"gezaehlt (%d): %d%n", 2 * LOOPS, cntr.getCount());
            System.err.printf(
            		"Laufzeit: %.1f s%n%n",(endTime - startTime) / 1000.0);
        } catch (InterruptedException neverHappens) {
        }
    }
}
