/*
 * SemaphoreCounter.java
 */

import java.util.concurrent.Semaphore;

/**
 * Implementiert einen threadsicheren Zaehler mithilfe der Klasse
 * <code>java.util.Semaphore</code>:
 */
public class SemaphoreCounter implements ICounter {
	private Semaphore s = new Semaphore(0);
    
	public void increment() {
		s.release();
	}

	public int getCount() {
		return s.availablePermits();
	}

}
