/**
 * MutexCounter.h
 */
#ifndef MUTEXCOUNTER_H
#define MUTEXCOUNTER_H

#include "ICounter.h"
#include <pthread.h>

/**
 * Die Klasse MutexCouter implementiert die Schnittstelle ICounter threadsicher
 * mittels Mutex.
 */
class MutexCounter : public ICounter{
public:

    MutexCounter();
    virtual void increment();
    virtual int getCount() const;
    virtual ~MutexCounter();

private:
    int count;
    pthread_mutex_t lock;
};

#endif // SIMPLECOUNTER_H
