/*
 * Runner.h
 */
#ifndef RUNNER_H
#define RUNNER_H

#include "ICounter.h"

/**
 * Die Klasse erzeugt ein Objekt zur Ausfuehrung von einer festgelegten 
 * Anzahl von Zaehleraufrufen.
 * <p>
 * Die Klasse Runner selbst ist nicht threadsicher. Die Methode getTime()
 * darf aber aus anderen Threads aufgerufen werden, wenn die Methode run()
 * beendet ist.
 */
class Runner{
public:
    /**
     * Erzeugt ein Ausfuehrungsobjekt.
     * 
     * @param cntr zu verwendender Zaehle.
     * @param cnt  Anzahl der Zaehleraufrufe.
     */
    Runner(ICounter* cntr, int cnt);
	
    /**
     * Ausfuehrungsmethode.
     */
    void* run();
    
    /**
     * Gibt die Laufzeit der Ausfuehrungsmethode zurueck.
     * 
     * @return Laufzeit.
     */
    double getTime() const;

private:
    double runTime;
    int loopCount;
    ICounter* counter;
};

/**
 * Globale Funktion um die Aufrufmethode der Klasse Runenr von pthread_create
 * zu rufen.
 * 
 * @param runner ausfuehrendes Runner-Objekt.
 */
void* run(void *runner);

#endif // RUNNER_H
