/*
 * AbstractPhilosopher.java
 */

/**
 * Die Klasse implementiert alle Ablaeufe eines speisenden Philosophen
 * soweit sie nicht mit der Gefahr eines Deadlocks verbunden sind.
 * Ein Deadlock kann naemlich nur bei Ergreifen der beiden Gabeln entstehen.
 * Dieses ist daher in die Unterklasse ausgelagert.
 */
public abstract class AbstractPhilosopher implements Runnable {
    /**
     * hier wird die Thread-lokale Variable cnt definiert. Sie dient dazu,
     * die Anzahl der Aktionen des Philosophen-Threads innerhalb anderer
     * Klassen des Threads (in der Fehlermeldung der Klasse Fork) verfuegbar
     * zu machen.
     */    
    private static final ThreadLocal<Integer> cnt = new ThreadLocal<Integer>();

    /**
     * Die vorgesehene Anzahl von Threadaktionen.
     */
    protected int maxCount;

    /**
     * Die linke Gabel.
     */
    protected final Fork leftFork;
    
    /**
     * Die rechte Gabel.
     */
    protected final Fork rightFork;
    
    /**
     * Erzeugt einen Philosophen.
     * 
     * @param leftFork  linke Gabel.
     * @param rightFork rechte Gabel.
     * @param maxCount Anzahl der Essvorgaenge.
     */
    public AbstractPhilosopher(Fork leftFork, Fork rightFork, int maxCount) {
        this.leftFork = leftFork;
        this.rightFork = rightFork;
        this.maxCount = maxCount;
    }

    public void run() {
    	for (int i = 0; i < maxCount; i++) {
            // denken ...
            cnt.set(i + 1);
    		getForks();
    		// essen ... (evtl. Thread.sleep(..) aufrufen.)
            // aber: in jedem Fall garantieren, dass putForks()
            // aufgerufen wird !! (try .. finally)
    		putForks();
    	}
    	System.out.println(Thread.currentThread().getName() + " ist satt.");
    }
    
    /**
     * Beiden Gabeln werden fuer den exklusiven Gebrauch reserviert
     * (ergriffen). Wenn die Gabeln nicht beide verfuegbar sind wird
     * gewartet. 
     */
    protected abstract void getForks();

    /**
     * Legt beide Gabeln ab.
     */
    private void putForks() {
        leftFork.release();
        rightFork.release();
    }

    /**
     * Gibt die bisher durchgefuehrte Anzahl der Aktionen des momentanen
     * Threads zurueck. Der Aufruf ist nur innerhalb des Threads, dessen
     * <code>AbstractPhilosopher.run()</code> ausgefuehrt wird, sinnvoll.
     * 
     * @return bisherige Anzahl von Aktionen.
     */
    public static int getCurrentCount() {
        return cnt.get();
    }
}
