/*
 * NaivePhilosopher.java
 */

/**
 * Diese Klasse realisiert den Handlungsstrang eines Philosophen, der immer
 * wieder versucht, mittels zweier Gabeln eine gewisse Zeit zu essen.
 * <p>
 * Hinsichtlich des Zugriffs auf die beiden benoetigten Gabeln wird keine
 * besondere Vorsicht beachtet. Stets wird zuerst die linke, dann die rechte
 * Gabel ergriffen. Dies kann bei zwei gleich handelnden Philosophen zum
 * Deadlock fuehren.
 */
public class NaivePhilosopher extends AbstractPhilosopher {
    /**
     * Erzeugt einen Philosophen.
     * 
     * @param leftFork  linke Gabel.
     * @param rightFork rechte Gabel.
     * @param count Anzahl der Essvorgaenge.
     */
	public NaivePhilosopher(Fork leftFork, Fork rightFork, int count) {
		super(leftFork, rightFork, count);
	}
    
	/**
     * Ergreift beide Gabeln in fester Reihenfolge.
     */
    protected void getForks() {
        leftFork.acquire();
        rightFork.acquire();
    }
}
