/*
 * PrudentPhilosopher.java
 */

/**
 * Diese Klasse realisiert den Handlungsstrang eines Philosophen, der immer
 * wieder versucht, mittels zweier Gabeln eine gewisse Zeit zu essen.
 * <p>
 * Die ist eine deadlockvermeidende Implementierung eines Philosophen.
 * Die Deadlockvermeidung beruht auf der Technik
 * des resource odering. Bei dieser Implementierung wird stets zuerst die
 * Gabel mit dem kleineren Wert von <code>hashCode()</code> ergriffen.
 */
public class PrudentPhilosopher extends AbstractPhilosopher {
    private boolean swap;
    
    public PrudentPhilosopher(Fork leftFork, Fork rightFork, int count) {        
        super(leftFork, rightFork, count);
        swap = leftFork.hashCode() > rightFork.hashCode();
    }
    
    protected void getForks() {
        if (swap) {
            rightFork.acquire();
            leftFork.acquire();
        }
        else {
            leftFork.acquire();
            rightFork.acquire();
        }
    }
}
