/*
 * ConditionVariableDeck.java
 */

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Implementierung des Parkdecks. Das Warten auf einen freien Parkplatz wird
 * durch eine Bedingungsvariable realisiert.
 */
public class ConditionVariableDeck implements IParkdeck {
    private int capacity;
    private Lock lock = new ReentrantLock();
    private Condition freeSlot = lock.newCondition();

    /**
     * Erzeugt ein neues Parkhaus.
     * 
     * @param capacity Anzahl der Parkplaetze.
     */
    public ConditionVariableDeck(int capacity) {
        this.capacity = capacity;
    }

    public void letIn(Car c) {
        lock.lock();
        try {
            while (capacity == 0)
                freeSlot.await();
            capacity--;
        } catch (InterruptedException neverHappens) {
        } finally {
            lock.unlock();
        }
    }

    public synchronized void letOut(Car c) {
        lock.lock();
        try {
            capacity++;
            freeSlot.signalAll();
        } finally {
            lock.unlock();
        }
    }

    public int getCapacity() {
        lock.lock();
        try {
            return capacity;
        } finally {
            lock.unlock();
        }
    }
}
