/*
 * PrimitiveDeck.java
 */

/**
 * Realisiert ein Parkhaus mit den Primitivoperatioen von Java
 * <code>synchronized, wait, notifyAll</code>.
 */
public class PrimitiveDeck implements IParkdeck {
    private int capacity;

    /**
     * Erzeugt ein neues Parkhaus.
     * 
     * @param capacity Anzahl der Parkplaetze.
     */
    public PrimitiveDeck(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void letIn(Car c) {
        try {
            while (capacity == 0) wait();
            capacity--;
        } catch (InterruptedException neverHappens) {
        }
    }

    public synchronized void letOut(Car c) {
        capacity++;
        notifyAll();
    }

    public int getCapacity() {
        return capacity;
    }
}
