/*
 * SemaphoreDeck.java
 */

import java.util.concurrent.Semaphore;

/**
 * Dies ist die einfachste Implementierung des Parkhauses. Es wird einfach eine
 * Semaphore zum Zhlen verwendet.
 */
public class SemaphoreDeck implements IParkdeck {
    /**
     * Erzeugt ein neues Parkhaus.
     * 
     * @param capacity Anzahl der Parkplaetze.
     */
    private Semaphore capacitySemaphore;

    public SemaphoreDeck(int capacity) {
        capacitySemaphore = new Semaphore(capacity);
    }

    public void letIn(Car c) {
        try {
            capacitySemaphore.acquire();
        } catch (InterruptedException neverHappens) {
        }
    }

    public void letOut(Car c) {
        capacitySemaphore.release();
    }

    public int getCapacity() {
        return capacitySemaphore.availablePermits();
    }
}
