/*
 * bank_server.c simuliert einen Geldautomaten.
 * Auf diesen Server wird mit RPC zugegriffen.
 */
#include <rpc/rpc.h>
#include "bank.h"  /* Schnittstelle, aus rpcgen bank.x */

static int konto_nr [MAXKONTO] ;
static int konto_pin [MAXKONTO];
static int konto_stand [MAXKONTO];
static int started; /* zu Null initialisiert */

void initialize () {
     konto_nr [0] = 815; konto_pin[0] = 4711; konto_stand[0] = 1000;
     konto_nr [1] = 816; konto_pin[1] = 4710; konto_stand[1] = 0;
     konto_nr [2] = 817; konto_pin[2] = 4709; konto_stand[2] = 1000;
     started = true;
}

int suche (int nr, int pin) {
    int i;
    for (i = 0; i < MAXKONTO; i++) {
       if (konto_nr [i] == nr)
          if (konto_pin[i] == pin) return i;
          else return -1;
    }
    return -1;
}

/*
 * Kontenstandroutine
 */
bank_ergebnis *val_5_svc (bank_kontoId *anforderung, struct svc_req *request) {
   int kto_index;
   static bank_ergebnis ergebnis;
   if (started == false) initialize();
    /*
    * Konto berprfen
    */
   kto_index = suche (anforderung->kto_nr, anforderung->kto_pin);
   if (kto_index < 0)
      /* illegale Kontonummer */
      ergebnis.status = konto_ungueltig ;
   else
      ergebnis.status = bank_OK ;
   return &ergebnis;

}

/*
 * Kontenstandroutine
 */
bank_ergebnis *stand_5_svc (bank_kontoId *anforderung, struct svc_req *request) {
   int kto_index;
   static bank_ergebnis ergebnis;
   if (started == false) initialize();
    /*
    * Konto berprfen
    */
   kto_index = suche (anforderung->kto_nr, anforderung->kto_pin);
   if (kto_index < 0)
      /* illegale Kontonummer */
      ergebnis.status = konto_ungueltig ;
   else {
      ergebnis.bank_ergebnis_u.kto_stand = konto_stand[kto_index];
      ergebnis.status = bank_OK ;
   }
   return &ergebnis;

}

/*
 * Auszahlungsroutine
 */
bank_ergebnis *aus_5_svc (bank_anforderung *anforderung, struct svc_req *request) {
   int kto_index;
   static bank_ergebnis ergebnis;
   if (started == false) initialize();
    /*
    * Konto berprfen
    */
   kto_index = suche (anforderung->kto_nr, anforderung->kto_pin);
   if (kto_index < 0)
      /* illegale Kontonummer */
      ergebnis.status = konto_ungueltig ;
   else
      if (konto_stand[kto_index] < anforderung->bewegung)
         ergebnis.status = konto_ungedeckt;
   else {
      konto_stand[kto_index] -= anforderung->bewegung;
      ergebnis.bank_ergebnis_u.kto_stand = konto_stand[kto_index];
      ergebnis.status = bank_OK ;
   }
   return &ergebnis;

}
