/*
 * Car.java
 */

import java.util.Random;

/**
 * Simuliert ein in das Parkhaus ein-/ausfahrendes Auto durch einen Thread.
 */
public class Car implements Runnable {
    private Random r = new Random();
    private IParkdeck parking;
    private String name;

    public Car(String name, IParkdeck parking) {
        this.parking = parking;
        this.name = name;
    }

    private void randomSleeping() {
        int sec = 5 + r.nextInt(10);
        try {
            Thread.sleep(sec * 1000);
        } catch (InterruptedException neverHappens) {
        }
    }

    public void run() {
        while (true) {
            randomSleeping();
            System.out.println(this + " waiting");
            parking.letIn(this);
            System.out.println(this + " entering");
            randomSleeping();
            System.out.println(this + " leaving");
            parking.letOut(this);
        }
    }

    public String toString() {
        return name;
    }
}
