/* bank.x - Bankautomat, Schnittstellen-Spezifikationen */

const MAXKONTO = 100;
const true = 1;
const false = 0;

enum bank_status {
        bank_OK = 1,
        konto_ungedeckt = 2,
        konto_ungueltig = 3
        } ;

/* Eingabeparameter - Kontonummer, Pin und Vernderungsbetrag */
struct bank_anforderung {
        int kto_nr;
        int kto_pin;
        int bewegung;
        } ;

/* Eingabeparameter - nur die Kontonummer&Pin */
struct bank_kontoId {
        int kto_nr;
        int kto_pin;
        } ;

/* Ausgabeparameter - der aktuelle Kontostand und der Status des Ergebnisses */
union bank_ergebnis switch (bank_status status) {
        case bank_OK : int kto_stand;
        case konto_ungedeckt : void;
        case konto_ungueltig : void;
        } ;

/* Programmdefinition - ein Programm, eine Version, eine Prozedur */
program BANKPROG {
   version BANKVERS {
      bank_ergebnis VAL(bank_kontoId) = 1;
      bank_ergebnis STAND(bank_kontoId) = 2;
      bank_ergebnis AUS(bank_anforderung) = 3;
      } = 5;  /* Versionsnummer */
   } = 0x2000009d; /* Programmnummer */

