/*
 * bank_client.c Test-Client fr den Bankautomaten
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <rpc/rpc.h>
#include "bank.h"       /* Schnittstelle, aus rpcgen bank.x */

int main(int argc, char *argv[]) {

   int choose, konto, pin, loop;
   char *wel = "Herzlich Willkommen bei der RPC-Bank.\nBitte Kontonummer eingeben: ";
   char *wel2 = "Bitte 4-stellige PIN eingeben: ";
   char *next = "\nGeld abheben        (1)\nKontostand abfragen (2)\nVerbindung beenden  (99)\nIhre Eingabe: ";
   char *ciao = "Vielen Dank, und herzlichen Glckwunsch\nwenn Sie die PIN nur geraten haben. \n";

   CLIENT *cl;

if (argc != 2) {
      printf ("Aufruf: %s server\n", argv[0]) ;
      exit(1);
      }
   /* verbinde Client mit Host, der als 1. Argument angegeben wurde */
   cl = clnt_create (argv[1], BANKPROG, BANKVERS, "tcp") ;
   if (cl == NULL) {
       clnt_pcreateerror (argv[1]) ;
       exit(2);
       }
   /*
    * Begren und Kontonummer erfragen
    * aktuellen Kontostand ausgeben
    * Abbruch, falls ungltig
    */
   printf("%s", wel);
   scanf("%d", &konto);
   printf("%s", wel2);
   scanf("%d", &pin);
   if (val (cl, konto, pin) == false) {
        printf("\nAbbruch: Falsche Kontonummer bzw. Pin.\n");
        exit(7);
   }

   loop = true;
   while(loop) {
         /*
          * Zu Beginn der Schleife wird gefragt, was der
          * Kunde mit seinem Konto machen will.
          */
         printf("%s", next);
         scanf("%i", &choose);
         /*
          * Nachdem der Kunde gewhlt hat, wird in ein
          * entsprechendes Unterprogramm gesprungen.
          */
         if (choose == 1) {loop = aus(cl, konto, pin);}
         if (choose == 2) {loop = stand(cl, konto, pin);}
         if (choose == 99) {
                printf("\n%s", ciao);
                loop = false;
                }
      }
   return(EXIT_SUCCESS);
}

/*
 * Die Hilfsfunktionen :
 */

int val(CLIENT *cl, int konto, int pin) {  // berprfen, ob gltiger User

   bank_ergebnis *ergebnis;
   bank_kontoId kontoId;

   kontoId.kto_nr = konto;
   kontoId.kto_pin = pin;

   ergebnis = val_5 (&kontoId, cl);
   if (ergebnis == NULL) {
        clnt_perror (cl, "Host") ;
        exit(3);
        }
   if (ergebnis->status == bank_OK)  return (true);
   return(false);
}

int stand(CLIENT *cl, int konto, int pin) {  // Abfrage des Kontostands

   bank_ergebnis *ergebnis;
   bank_kontoId anforderung;

   anforderung.kto_nr = konto;
   anforderung.kto_pin = pin;
   ergebnis = stand_5 (&anforderung, cl);
   if (ergebnis == NULL) {
        clnt_perror (cl, "Host") ;
        exit(3);
        }
   if (ergebnis->status == bank_OK) {
        printf("\nIhr aktueller Kontostand: %i\n\n",
           ergebnis->bank_ergebnis_u.kto_stand);
        return (true);
	}
    // konto_ungueltig :
    printf("\nAbbruch: Falsche Kontonummer bzw. Pin. [%d]\n", ergebnis->status);
                // kann nur vorkommen, wenn das Konto gesperrt wurde
    return(false);
    
}

int aus(CLIENT *cl, int konto, int pin) { // Auszahlung, mit berprfung der Bonitt

#define U_LIMIT 50
#define O_LIMIT 1000

   int i, out_sum;
   bank_ergebnis *ergebnis;
   bank_anforderung anforderung;

   printf("\nWieviel Geld mchten Sie von Konto %d abheben? \n         50 Eur (1)\n        100 Eur (2)\n        200 Eur (3)\n        400 Eur (4)\n        anderen Betrag (9)\n        Abbruch (99)\nIhre Eingabe: ", konto);
   scanf("%i", &i);

   switch (i) {
      case 1 : out_sum = 50; break;
      case 2 : out_sum = 100; break;
      case 3 : out_sum = 200; break;
      case 4 : out_sum = 400; break;
      case 9 :
        printf("\nBitte geben Sie den Betrag an: ");
        scanf("%i", &out_sum);
        if (out_sum < U_LIMIT || out_sum > O_LIMIT) {
           printf ("\nAbbruch: Betrag ungltig!\n");
           out_sum = 0;
        }
        break;
      case 99 :
        printf("\nAbbruch\n");
        out_sum = 0;
        break;
      }

   anforderung.kto_nr = konto;
   anforderung.kto_pin = pin;
   anforderung.bewegung = out_sum;
   ergebnis = aus_5 (&anforderung, cl);
   if (ergebnis == NULL) {
        clnt_perror (cl, "Host") ;
        exit(3);
        }
   if (ergebnis->status == bank_OK) {
        printf("\nIhr neuer Kontostand: %i\n\n",
           ergebnis->bank_ergebnis_u.kto_stand);
        return (true);
	}
  if (ergebnis->status == konto_ungedeckt) {
        printf("\nDer Kontostand ( %i ) reicht fr diese Abhebung nicht aus.\n",
           ergebnis->bank_ergebnis_u.kto_stand);
        return (true);
	}
   // konto_ungueltig :
        printf("\nAbbruch: Falsche Kontonummer bzw. Pin. [%d]\n", ergebnis->status);
        return(false);
      
}
