/*
 * Main.java
 */

import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * Beispiel fuer einen einfachen Http-Server. Das Beispiel demonstriert die
 * Wiederverwendung von Threads.
 */
public final class Main {

    public static void main(String[] args) throws Exception {
        /*
         * Verarbeite Eingabeparameter.
         */
        Parameter.setPort(args.length > 0 ? Integer.parseInt(args[0]) : -1);
        Parameter.logParameters();
        /*
         * Starte den Thread-Pool
         */
        Executor pool = Executors.newCachedThreadPool();
        /*
         * Starte die eigentliche Serveraktivitt.
         */
        ServerSocket server = new ServerSocket(Parameter.getPort());
        while (true) {
            /*
             * Warte auf einen neuen Request.
             */
            Socket socket = server.accept();
            /*
             * Fuer das Lesen des Http-Request wird hoechstens eine 
             * festgelegte Zeitspanne zugelassen.
             * Sonst gibt es eine java.IO.InterruptedIOException.
             */
            socket.setSoTimeout(Parameter.getTimeout());
            socket.setTcpNoDelay(true);
            /*
             * Lasse den neuen Ablauf durch einen der vorhandenen Threads
             * ausfuehren.
             */
            pool.execute(new Worker(socket));
        }
    }
}
