/*
 * MimeTypes.java
 */

import java.util.HashMap;

/**
 * Verwaltet Mime-Types.
 */
public final class MimeTypes {
    private MimeTypes() {}

    /**
     * Realisiert die Abbildung Dateiendung -> Mime-Typ.
     * 
     * @param fileName Dateiname.
     * @return Mime-Typ
     */
    public static String getType(String fileName) {
        int index = fileName.lastIndexOf('.');
        String ct = null;
        if (index > 0) {
            ct = map.get(fileName.substring(index));
        }
        if (ct == null) {
            ct = "unknown/unknown";
        }
        return ct;
    }

    private static final HashMap<String, String> map = 
        new HashMap<String, String>();

    static {
        map.put("", "content/unknown");
        map.put(".uu", "application/octet-stream");
        map.put(".exe", "application/octet-stream");
        map.put(".ps", "application/postscript");
        map.put(".pdf", "application/pdf");
        map.put(".zip", "application/zip");
        map.put(".sh", "application/x-shar");
        map.put(".tar", "application/x-tar");
        map.put(".doc", "application/msword");
        map.put(".snd", "audio/basic");
        map.put(".au", "audio/basic");
        map.put(".wav", "audio/x-wav");
        map.put(".gif", "image/gif");
        map.put(".jpg", "image/jpeg");
        map.put(".jpeg", "image/jpeg");
        map.put(".htm", "text/html");
        map.put(".html", "text/html");
        map.put(".text", "text/plain");
        map.put(".c", "text/plain");
        map.put(".cc", "text/plain");
        map.put(".c++", "text/plain");
        map.put(".h", "text/plain");
        map.put(".pl", "text/plain");
        map.put(".txt", "text/plain");
        map.put(".java", "text/plain");
    }
}
