/*
 * Fork.java
 */

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Diese Klasse realisert eine Gabel als eine verteilt genutzte Ressource.
 * Mittels Timeout wird erkannt, ob ein Deadlock vorliegt.
 */
public class Fork {
    /**
     * Festgelegtes Timeout fuer die Deadlockerkennung (in Sekunden).
     */
	public static final int WAIT_FOR_LOCK = 2;	
    
	private ReentrantLock lock = new ReentrantLock();
	
    /**
     * Versucht eine Gabel zur erlangen. Die Methode wartet so lange bis dies
     * moeglich ist. Anschliessend wird die Gabel fuer fremde Zugriffe gesperrt,
     * bis mittels <code>release</code> eine erneute Freigabe erfolgt. Nach der
     * in der Variablen <code>WAIT_FOR_LOCK</code> angegebenen Zeitspanne
     * in Sekunden wird gemeldet, dass ein Deadlock vorliegt.
     */
    public void acquire() {
    	try {
			if (lock.tryLock(WAIT_FOR_LOCK, TimeUnit.SECONDS)) return;
		} catch (InterruptedException neverHappens) {
		}
    	System.err.println(
    		Thread.currentThread().getName() + " ist im deadlock nach " +
    	    NaivePhilosopher.getCurrentCount() + " Aktionen.");
    	lock.lock();
    }
    
    /**
     * Die Gabel wird wieder abgelegt und damit erneut verfuegbar.
     */
    public void release() {
    	lock.unlock();
    }
}
