/*
 * Main.java
 */

/**
 * Hauptprogramm zur Demonstration von deadlocks.
 * Es werden zwei Threads erzeugt, die wegen zyklischer Abhngigkeit
 * Gefahr laufen, sich wechselseitig zu blockieren.
 * <p>
 * Das Beispiel entspricht dem bekannten "Philosophenproblem".
 */
public class Main {
    /**
     * Anzahl der wiederholten Versuche der Kooperation.
     */
	private static final int LOOPS = 10000;
    
    /**
     * deadlocksicher oder nicht?
     */
    private static final boolean DEADLOCK_SAFE = false;

	public static void main(String[] args) throws Exception {
		Fork fork1 = new Fork();
		Fork fork2 = new Fork();
        AbstractPhilosopher p1, p2;        
        if (DEADLOCK_SAFE) {
            System.out.println("kein Problem!");
            p1 = new PrudentPhilosopher(fork1, fork2, LOOPS);
            p2 = new PrudentPhilosopher(fork2, fork1, LOOPS);
        } else {
            System.err.println("riskant!");
            p1 = new NaivePhilosopher(fork1, fork2, LOOPS);
            p2 = new NaivePhilosopher(fork2, fork1, LOOPS);
        }
		new Thread(p1, "1. Philosoph").start();
		new Thread(p2, "2. Philosoph").start();
        /*
         * Versuchen Sie alternaltiv zur letzten Zeile mal:
         * p2.run();
         * Welcher Thread fuehrt jetzt den 2. Philosophen aus?
         */
	}
}
