/*
 * LockedCounter.java
 */

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Implementiert einen threadsicheren Zaehler mithilfe der Klasse
 * <code>java.util.locks.ReentrantLock</code>:
 */
public class LockedCounter implements ICounter {
	private Lock lock = new ReentrantLock(false);
	int count = 0;
	
	public void increment() {
        lock.lock();
        try {                   // das Ideom fuer unlock !!
            count++;            // kritischer Bereich.
        } finally {
            lock.unlock();
        }
    }

	public int getCount() {
        lock.lock();        // noetig wegen Memory Synchronisation
        try {
            return count;
        } finally {
            lock.unlock();
        }
    }
}
