/*
 * ReadWriteLockCounter.java
 */

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * Implementiert einen threadsicheren Zaehler mithilfe der Klasse
 * <code>java.util.locks.ReentrantReadWriteLock</code>:

 */
public class ReadWriteLockCounter implements ICounter {
	private int count = 0;
	private Lock read;
	private Lock write;
	
	public ReadWriteLockCounter() {
		ReadWriteLock r = new ReentrantReadWriteLock();
		read = r.readLock();
		write = r.writeLock();
	}
	public void increment() {
		write.lock();
        try {
            count++;
        } finally {
            write.unlock();
        }
	}

	public int getCount() {
        read.lock();
        try {
            return count;
        } finally {
            read.unlock();
        }
    }
}
