/*
 * Runner.java
 */

/**
 * Runnable zur Ausfuehrung von Tests diverser Zaehlerobjekte.
 */
public class Runner implements Runnable {
    private final ICounter counter;
    private final int numberOfLoops;
    
    /**
     * Erzeugt ein neues Ausfuehrungsobjekt.
     * 
     * @param counter zu verwendender Zaehler.
     * @param numberOfLoops Anzahl der Zaehleraufrufe.
     */
    public Runner(ICounter counter, int numberOfLoops) {
        this.counter = counter;
        this.numberOfLoops = numberOfLoops;
    }

    public void run() {
        for (int i = 1; i <= numberOfLoops; i++) {
            counter.increment();
        }
    }
}
