#ifndef AC_ANAL_L_P_FO_SDOM_H
#define AC_ANAL_L_P_FO_SDOM_H

#include <systemc-ams>

SCA_TDF_MODULE(lpo1sdom)
{
  private:
  sca_tdf::sca_ltf_nd ltf_nd;
  sca_util::sca_vector<double> denom;
  sca_util::sca_vector<double> numer;

  public:
   sca_tdf::sca_in<double> sigin;
   sca_tdf::sca_out<double> sigout; 

   void initialize()
   {
     numer(0) = 1.0;
     denom(0) = 1.0;
     denom(1) = 2.65E-3;
   }

   void set_attributes()
   {
     sigout.set_timestep(1.0, sc_core::SC_US);
     sigout.set_rate(1);
     sigin.set_rate(1);
     sigout.set_delay(1);
   }

   void processing()
   {
     sigout.write(ltf_nd(numer, denom, sigin.read(),1.0));
   }

   SCA_CTOR(lpo1sdom){ }

   ~lpo1sdom() { }
};

SCA_TDF_MODULE(lpo2sdom)
{
  private:
  sca_tdf::sca_ltf_nd ltf_nd;
  sca_util::sca_vector<double> denom;
  sca_util::sca_vector<double> numer;

  public:
   sca_tdf::sca_in<double> sigin;
   sca_tdf::sca_out<double> sigout;

   void initialize()
   {
     numer(0) = 1.0;
     denom(0) = 1.0;
     denom(1) = 4.3E-3;
     denom(2) = 7.0E-6;
   }

    void set_attributes()
   {
     sigout.set_timestep(1.0, sc_core::SC_US);
     sigout.set_rate(1);
     sigout.set_delay(1);
     sigin.set_rate(1);
   }

   void processing()
   {
     sigout.write(ltf_nd(numer, denom, sigin.read(),1.0));
   }

   SCA_CTOR(lpo2sdom){ }
   ~lpo2sdom() { }
};


SCA_TDF_MODULE(lpo3sdom)
{
  private:
  sca_tdf::sca_ltf_nd ltf_nd;
  sca_util::sca_vector<double> denom;
  sca_util::sca_vector<double> numer;

  public:
   sca_tdf::sca_in<double> sigin;
   sca_tdf::sca_out<double> sigout;

   void initialize()
   {
     numer(0) = 1.0;
     denom(0) = 1.0;
     denom(1) = 1.6E-3;
     denom(2) = 7.0E-6;
   }

   void set_attributes()
   {
     sigout.set_timestep(1.0, sc_core::SC_US);
     sigout.set_rate(1);
     sigout.set_delay(1);
     sigin.set_rate(1);
   }

   void processing()
   {
     sigout.write(ltf_nd(numer, denom, sigin.read(),1.0));
   }

   SCA_CTOR(lpo3sdom){ }
   ~lpo3sdom() { }
};

/*
SCA_TDF_MODULE(lpacfosdom)
{
  private:
   sca_tdf::sca_signal<double> sig0;
   sca_tdf::sca_signal<double> sig1;
   
  public:
   sca_tdf::sca_in<double> sigin;
   sca_tdf::sca_out<double> sigout;
   
   lpo1sdom *f1;
   lpo2sdom *f2;
   lpo3sdom *f3; 

   SCA_CTOR(lpacfosdom)
   {
     f1 = new lpo1sdom("f1");
     f2 = new lpo2sdom("f2");
     f3 = new lpo3sdom("f3"); 
    
     f1->sigin(sigin);
     f1->sigout(sigout);
     
     f2->sigin(sig0);
     f2->sigout(sig1);
   
     f3->sigin(sig1);
     f3->sigout(sigout);   
   }
   ~lpacfosdom() 
   {
     if(f1 != NULL) { delete(f1); f1 = NULL; }
     if(f2 != NULL) { delete(f2); f2 = NULL; }
     if(f3 != NULL) { delete(f3); f3 = NULL; }   
   }
};
*/
#endif

