#ifndef ADC_H
#define ADC_H

using namespace std;

#include <systemc-ams>
#include "commonsrcs.h" 

const double TOL = 0.5;
const double MULTFACTOR = 8.5E+6;

SCA_TDF_MODULE(integrator)
{
  sca_tdf::sca_in<bool> cntrlin;
  sca_tdf::sca_in<double> valuein;
  sca_tdf::sca_out<double> valueout;
  bool cntrlvalue;
  double currtime;
  double invalue;
  double lasttime;
  double lastinvalue;
  double lastoutvalue;
  double outvalue;
  

  void set_attributes()
  {
    valueout.set_timestep(1.0, sc_core::SC_US);
    cntrlin.set_rate(1);
    valuein.set_rate(1);
    valueout.set_rate(1);
  }

  void processing()
  {
    cntrlvalue = cntrlin.read();
    invalue = valuein.read();
    currtime = valueout.get_time().to_seconds();
 
    if(cntrlvalue == false)
    {
       outvalue = (currtime - lasttime)*(invalue + lastinvalue)*0.5;
    }
    else if(cntrlvalue == true)
    {
      outvalue = 0.0;
      lastoutvalue = 0.0;
      lastinvalue = 0.0;
      lasttime = currtime;
     
    }
    lasttime = currtime;
    lastinvalue = invalue;
    lastoutvalue = outvalue;
    lastoutvalue *= MULTFACTOR;
    
    std::cout<<std::scientific<<invalue<<"\t"<<std::scientific<<lastoutvalue<<std::endl;
    
    valueout.write(fabs(lastoutvalue));
  }

  SCA_CTOR(integrator):cntrlvalue(false),
                       currtime(0.0),
                       lastinvalue(0.0),
                       lasttime(0.0),
                       outvalue(0.0){ }
  ~integrator(){ }
};
        
SCA_TDF_MODULE(comparator)
{
  sca_tdf::sca_in<double> valuein1;
  sca_tdf::sca_in<double> valuein2;
  sca_tdf::sca_out<bool> valueout;
  double din1;
  double din2;
  bool cntrlout;


  void set_attributes()
  {
    valueout.set_timestep(1.0, sc_core::SC_US);
    valuein1.set_rate(1);
    valuein2.set_rate(1);
    valueout.set_rate(1);
    valueout.set_delay(1);
  }

  void processing()
  {
    din1 = valuein1.read();
    din2 = valuein2.read();
    cntrlout = din1 < din2 ? true : false;
    valueout.write(cntrlout);
    /*
    cout<<std::scientific<<din1<<" "<<std::scientific<<din2<<endl;
    */
  }

  SCA_CTOR(comparator) : din1(0.0), 
                         din2(0.0),
                         cntrlout(false){ }
  ~comparator(){ }
};

SCA_TDF_MODULE(counter)
{
  sca_tdf::sca_in<bool> cntrlsig;
  sca_tdf::sca_out<unsigned int> countout;
  unsigned int count;
  bool cntrlvalue;

  void set_attributes()
  {
    countout.set_timestep(1.0, sc_core::SC_US);
    countout.set_rate(1);
    cntrlsig.set_rate(1);
  }

  void processing()
  {
    cntrlvalue = cntrlsig.read();
    if(cntrlvalue == true) { count = 0; }
    else { count += 1; }
    countout.write(count);
  }
 
  SCA_CTOR(counter) : count(0){ }
  ~counter() { }
};
    
#endif

