#ifndef ADDSUB_H
#define ADDSUB_H

#include <systemc>

SC_MODULE(adder2bit)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;

  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;  

  void adder2bit_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
  
      if(b0 == false && b1 == false && b2 == false)
      {
        b3 = false;
        b4 = false;
      }
      else if(b0 == true && b1 == false && b2 == false)
      {
        b3 = true;
        b4 = false;
      } 
      else if(b0 == false && b1 == true && b2 == false)
      {
        b3 = true;
        b4 = false;
      } 
      else if(b0 == false && b1 == false && b2 == true)
      {
        b3 = true;
        b4 = false;
      }
      else if(b0 == true && b1 == true && b2 == false)
      {
        b3 = false;
        b4 = true;
      }
      else if(b0 == true && b1 == false && b2 == true)
      {
        b3 = false;
        b4 = true;
      }
      else if(b0 == false && b1 == true && b2 == true)
      {
        b3 = false;
        b4 = true;
      }
      else if(b0 == true && b1 == true && b2 == true)
      {
        b3 = true;
        b4 = true;
      }
      out0.write(b3);
      out1.write(b4);
    }
  }

  SC_CTOR(adder2bit)
  {
    SC_THREAD(adder2bit_proc0);
    sensitive << in0 << in1 << in2;
  }

  ~adder2bit(){ }
};

SC_MODULE(xorgate)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
 /* sc_core::sc_out<bool> out1; */
  bool b0;
  bool b1;
  bool b2;

  void xorgate_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      b1 = in1.read();
      b2 = ((b0 & !b1) | (!b0 & b1));
      out0.write(b2);
     /* out1.write(b2); */
    }
  }

  SC_CTOR(xorgate)
  {
    SC_THREAD(xorgate_proc0);
    sensitive << in0 << in1;
  }

  ~xorgate(){ }
};

SC_MODULE(addsub4bit)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> in8;

  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;
  sc_core::sc_out<bool> out2;
  sc_core::sc_out<bool> out3;
  sc_core::sc_out<bool> out4;
  
  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;

  adder2bit ad0;
  adder2bit ad1;
  adder2bit ad2;
  adder2bit ad3;
 
  xorgate xog0;
  xorgate xog1;
  xorgate xog2;
  xorgate xog3;

  SC_CTOR(addsub4bit):ad0("ad0"),ad1("ad1"),ad2("ad2"),ad3("ad3"),
                      xog0("xog0"),xog1("xog1"),xog2("xog2"),xog3("xog3"),
                      sig0("sig0"), sig1("sig1"), sig2("sig2"), sig3("sig3"),
                      sig4("sig4"), sig5("sig5"), sig6("sig6"), sig7("sig7")
  {
    ad0.in0(in8);
    ad0.in1(in0);
    ad0.in2(sig0);
    ad0.out0(sig4);
    ad0.out1(out0);

    ad1.in0(in2);
    ad1.in1(sig1);
    ad1.in2(sig4);
    ad1.out0(sig5);
    ad1.out1(out1);

    ad2.in0(in4);
    ad2.in1(sig2);
    ad2.in2(sig5);
    ad2.out0(sig6);
    ad2.out1(out2);

    ad3.in0(in6);
    ad3.in1(sig3);
    ad3.in2(sig6);
    ad3.out0(out3);
    ad3.out1(out4);

    xog0.in0(in8);
    xog0.in1(in1);
    xog0.out0(sig0);

    xog1.in0(in8);
    xog1.in1(in3);
    xog1.out0(sig1);

    xog2.in0(in8);
    xog2.in1(in5);
    xog2.out0(sig2);

    xog3.in0(in8);
    xog3.in1(in7);
    xog3.out0(sig3);

  }

  ~addsub4bit(){ }
};

    
#endif

