#ifndef BARRELSHIFT_H
#define BARRELSHIFT_H

#include <systemc>

const unsigned int MAX = 32;

SC_MODULE(barrelshift)
{
  sc_core::sc_in< sc_dt::sc_bv<MAX> > din0;
  sc_core::sc_in< sc_dt::sc_bv<MAX> > din1;
  sc_core::sc_in<bool> shiftright;
  sc_core::sc_out< sc_dt::sc_bv<MAX> > dout;
  sc_dt::sc_bv<MAX> tmp;
  sc_dt::sc_bv<MAX> tmp_out;
  unsigned int shiftlen;
  bool readyvalue;
  

  void barrelshift_proc0()
  {
    while(1)
    {
      wait();
      shiftlen = din1.read().to_int();
      if(shiftlen < (MAX - 1) && shiftlen > 0)
      {
        tmp = din0.read();
        if(shiftright.read() == true)
        {
          tmp_out = (tmp(shiftlen - 1, 0),
                     tmp(MAX - 1, shiftlen));
        }
        else if(shiftright.read() == false)
        {
          tmp_out = (tmp(MAX -  1 - shiftlen, 0),
                     tmp(MAX - 1, MAX - shiftlen));
        }
        readyvalue = true;
      }
      dout.write(tmp_out);
    }
  }

  SC_CTOR(barrelshift):tmp("00000000"),
                       tmp_out("00000000"),
                       shiftlen(0) 
  {
    SC_THREAD(barrelshift_proc0);
    sensitive << din0 << din1 << shiftright;
  }

  ~barrelshift(){ }
};

#endif

