#ifndef CDREADER_H
#define CDREADER_H

#include <systemc-ams>

SCA_TDF_MODULE(psd)
{
  sca_tdf::sca_in<double> inlightpos;
  sca_tdf::sca_out<double> voltage1;
  sca_tdf::sca_out<double> voltage2;
  double resistivity;
  double L;
  double W;
  double thickness;
  double sheet_resistance;
  double const_current;
  double voltage_val_1;
  double voltage_val_2;
  double pos;

  void initialize()
  {
    sheet_resistance = resistivity/(W*thickness);
  }

  void set_attributes()
  {
    voltage1.set_timestep(1.0, sc_core::SC_US);
    voltage2.set_timestep(1.0, sc_core::SC_US);
    inlightpos.set_rate(1);
    voltage1.set_rate(1);
    voltage2.set_rate(1);
  }

  void processing()
  {
    pos = inlightpos.read();
    voltage_val_1 = sheet_resistance*pos*const_current;
    voltage_val_2 = sheet_resistance*(L - pos)*const_current;
    voltage1.write(voltage_val_1);
    voltage2.write(voltage_val_2);
    /*
    std::cout<<resistivity<<"\t"<<W<<"\t"<<thickness<<std::endl;
    */
  }

  SCA_CTOR(psd):pos(0.0),
                voltage_val_1(0.0), 
                voltage_val_2(0.0),
                const_current(0.05)
  {
   /* initialize(); */
  }

  ~psd(){ }
};

SC_MODULE(instamplifier)
{
  sca_tdf::sca_in<double> inp0;
  sca_tdf::sca_in<double> inp1;
  sca_tdf::sca_out<double> outp;

  sca_eln::sca_tdf::sca_vsource v_in0;
  sca_eln::sca_tdf::sca_vsource v_in1;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_nullor nullr0;
  sca_eln::sca_nullor nullr1;
  sca_eln::sca_nullor nullr2;
  sca_eln::sca_r r0;
  sca_eln::sca_r r1;
  sca_eln::sca_r r2;
  sca_eln::sca_r r3;

  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node n3;
  sca_eln::sca_node n4;
  sca_eln::sca_node n5;
  sca_eln::sca_node n6;
  sca_eln::sca_node n7;
  sca_eln::sca_node_ref gnd;   
   
  SC_CTOR(instamplifier):v_in0("v_in0", 1.0),
                         v_in1("v_in1", 1.0), 
                         v_out("v_out", 1.0),
                         nullr0("nullr0"),
                         nullr1("nullr1"),
                         nullr2("nullr2"),
                         r0("r0", 500.0),
                         r1("r1", 500.0),
                         r2("r2", 75000000.0),
                         r3("r3", 500.0)
  {
    v_in0.inp(inp0);
    v_in0.p(n1);
    v_in0.n(gnd);    
  
    v_in1.inp(inp1);
    v_in1.p(n2);
    v_in1.n(gnd);

    v_out.outp(outp);
    v_out.p(n7);
    v_out.n(gnd);

    nullr0.nip(n1);
    nullr0.nin(n3);
    nullr0.nop(n3);
    nullr0.non(gnd);
 
    nullr1.nip(n2);
    nullr1.nin(n4);
    nullr1.nop(n4);
    nullr1.non(gnd);

    nullr2.nip(n5);
    nullr2.nin(n6);
    nullr2.nop(n7);
    nullr2.non(gnd);

    r0.p(n3);
    r0.n(n5);
    
    r1.p(n4);
    r1.n(n6);
  
    r2.p(n5);
    r2.n(n7);
   
    r3.p(n6);
    r3.n(gnd);
  }

  ~instamplifier(){ }
};


#endif
      
