#ifndef CLKGEN_H
#define CLKGEN_H

#include <systemc>

SC_MODULE(and2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;

  void and2_proc0()
  {
    while(1)
    {
      wait();
      out0.write(in0.read() & in1.read());
     }
   }

   SC_CTOR(and2)
   {
     SC_THREAD(and2_proc0);
     sensitive << in0 << in1;
   }

   ~and2(){ }
};


SC_MODULE(inv)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_out<bool> out0;

  void inv_proc0()
  {
    while(1)
    {
      wait();
      out0.write(!(in0.read()));
    }
  }

  SC_CTOR(inv)
  {
    SC_THREAD(inv_proc0);
    sensitive << in0;
  }

  ~inv(){ }
};

SC_MODULE(inv_out)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;
  bool b0;

  void inv_out_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      out0.write(!b0);
      out1.write(!b0);
    }
  }

  SC_CTOR(inv_out)
  {
    SC_THREAD(inv_out_proc0);
    sensitive << in0;
  }

  ~inv_out(){ }
};


SC_MODULE(nor2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;

  void nor2_proc0()
  {
    while(1)
    {
      wait();
      out0.write(!(in0.read() | in1.read()));
    }
  }

  SC_CTOR(nor2)
  {
    SC_THREAD(nor2_proc0);
    sensitive << in0 << in1;
  }

  ~nor2(){ }
};

SC_MODULE(nor2_out2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;
  bool b0;

  void nor2_out2_proc0()
  {
    while(1)
    {
      wait();
      b0 = !(in0.read() | in1.read());
      out0.write(b0);
      out1.write(b0);
    }
  }

  SC_CTOR(nor2_out2)
  {
    SC_THREAD(nor2_out2_proc0);
    sensitive << in0 << in1;
  }

  ~nor2_out2(){ }
};

SC_MODULE(nor3)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out0;

  void nor3_proc0()
  {
    while(1)
    {
      wait();
      out0.write(!(in0.read() | in1.read() | in2.read()));
    }
  }

  SC_CTOR(nor3)
  {
    SC_THREAD(nor3_proc0);
    sensitive << in0 << in1 << in2;
  }

  ~nor3(){ }
};


SC_MODULE(clkgen)
{
  sc_core::sc_in<bool> slct;
  sc_core::sc_in<bool> clk_in;
  sc_core::sc_out<bool> clk1;
  sc_core::sc_out<bool> clk2;
  sc_core::sc_out<bool> clk3;
  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;
  sc_core::sc_signal<bool> sig9;
  sc_core::sc_signal<bool> sig10;
  sc_core::sc_signal<bool> sig11;
  sc_core::sc_signal<bool> sig12;

  nor3 nor3_0;
  nor3 nor3_1;
  nor3 nor3_2;

  nor2 nor2_0;
  nor2 nor2_1;

  inv inv_0;
  inv inv_1;
  inv inv_2;
  inv inv_3;
  inv inv_4;

  inv_out inv_out_0;
  inv_out inv_out_1;
  inv_out inv_out_2;
  
  SC_CTOR(clkgen):nor3_0("nor3_0"), 
                  nor3_1("nor3_1"), 
                  nor3_2("nor3_2"),
                  nor2_0("nor2_0"), 
                  nor2_1("nor2_1"), 
                  inv_0("inv_0"),
                  inv_1("inv_1"), 
                  inv_2("inv_2"), 
                  inv_3("inv_3"),
                  inv_4("inv_4"), 
                  inv_out_0("inv_out_0"), 
                  inv_out_1("inv_out_1"),
                  inv_out_2("inv_out_2"),
                  sig0("sig0"), sig1("sig1"),
                  sig2("sig2"), sig3("sig3"),
                  sig4("sig4"), sig5("sig5"),
                  sig6("sig6"), sig7("sig7"),
                  sig8("sig8"), sig9("sig9"),
                  sig10("sig10")
   {
     nor3_0.in0(sig0);
     nor3_0.in1(sig3);
     nor3_0.in2(sig7);
     nor3_0.out0(sig6);
  
     nor3_1.in0(sig0);
     nor3_1.in1(sig3);
     nor3_1.in2(sig8);
     nor3_1.out0(sig5);

     nor3_2.in0(sig1);
     nor3_2.in1(sig2);
     nor3_2.in2(clk_in);
     nor3_2.out0(sig11);
      
     nor2_0.in0(sig6);
     nor2_0.in1(slct);
     nor2_0.out0(sig7);

     nor2_1.in0(sig5);
     nor2_1.in1(sig4);
     nor2_1.out0(sig8);  

     inv_0.in0(sig6);
     inv_0.out0(sig9);
    
     inv_1.in0(sig5);
     inv_1.out0(sig10);

     inv_2.in0(sig11);
     inv_2.out0(sig12);

     inv_3.in0(slct);
     inv_3.out0(sig4);

     inv_4.in0(clk_in);
     inv_4.out0(sig3);

     inv_out_0.in0(sig9);
     inv_out_0.out0(sig1);
     inv_out_0.out1(clk1);
  
     inv_out_1.in0(sig10);
     inv_out_1.out0(sig2);
     inv_out_1.out1(clk2);

     inv_out_2.in0(sig12);
     inv_out_2.out0(sig0);
     inv_out_2.out1(clk3);
   }

   ~clkgen(){ }
};

SC_MODULE(reconDff)
{
  sc_core::sc_in<bool> clk1;
  sc_core::sc_in<bool> clk2;
  sc_core::sc_in<bool> clk3;
  sc_core::sc_in<bool> din;
  sc_core::sc_in<bool> slct;
  sc_core::sc_out<bool> dout0;
  sc_core::sc_out<bool> dout1;

  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;
  sc_core::sc_signal<bool> sig9;
  sc_core::sc_signal<bool> sig10;
  sc_core::sc_signal<bool> sig11;

  and2 and2_0;
  and2 and2_1;
  and2 and2_2;
  and2 and2_3;
  and2 and2_4;
  and2 and2_5;

  inv inv_0;
  inv inv_1;

  nor2_out2 nor2_out2_0;
  nor2_out2 nor2_out2_1;

  nor3 nor3_0;
  nor3 nor3_1;

  SC_CTOR(reconDff): and2_0("and2_0"), 
                     and2_1("and2_1"), 
                     and2_2("and2_2"),
                     and2_3("and2_3"),
                     and2_4("and2_4"),
                     and2_5("and2_5"),
                     inv_0("inv_0"),
                     inv_1("inv_1"),
                     nor3_0("nor3_0"), 
                     nor3_1("nor3_1"),  
                     nor2_out2_0("nor2_out2_0"),
                     nor2_out2_1("nor2_out2_1")
   {
      and2_0.in0(din);
      and2_0.in1(clk1);
      and2_0.out0(sig2);
   
      and2_1.in0(clk1);
      and2_1.in1(sig1);
      and2_1.out0(sig4);

      and2_2.in0(slct);
      and2_2.in1(clk2);
      and2_2.out0(sig3);

      and2_3.in0(clk2);
      and2_3.in1(sig0);
      and2_3.out0(sig5);

      and2_4.in0(sig7);
      and2_4.in1(clk3);
      and2_4.out0(sig9);

      and2_5.in0(sig6);
      and2_5.in1(clk3);
      and2_5.out0(sig8);

      inv_0.in0(din);
      inv_0.out0(sig1);

      inv_1.in0(slct);
      inv_1.out0(sig0);

      nor3_0.in0(sig2);
      nor3_0.in1(sig3);
      nor3_0.in2(sig6);
      nor3_0.out0(sig7);

      nor3_1.in0(sig4);
      nor3_1.in1(sig5);
      nor3_1.in2(sig7);
      nor3_1.out0(sig6);

      nor2_out2_0.in0(sig9);
      nor2_out2_0.in1(sig11);
      nor2_out2_0.out0(sig10);
      nor2_out2_0.out1(dout0);

      nor2_out2_1.in0(sig8);
      nor2_out2_1.in1(sig10);
      nor2_out2_1.out0(sig11);
      nor2_out2_1.out1(dout1);
   }

   ~reconDff(){ }
};

#endif

