#ifndef DEC2IEEE754_H
#define DEC2IEEE754_H

#include <systemc>
#include <cstdlib>
#include <cstring>
#include <cstdio>

const unsigned int MAXFRBITS32M  = 48;
const unsigned int MAXFRBITS32   = 23;
const unsigned int MAXFRBITS32P  = 24;
const unsigned int MIDPOS32      = 11;
const unsigned int EXPSIZE32     = 8;
const unsigned int MAXFRBITS64   = 53;
const unsigned int MIDPOS64      = 27;
const unsigned int EXPSIZE64     = 11;
const unsigned int EXPO          = 2;
const sc_dt::sc_bv<MAXFRBITS32> ONE = "00000000000000000000001";

SC_MODULE(ieee754_32_arithmetic_all_bin)
{
  private:

    void decexp2bin(unsigned int ii, sc_dt::sc_bv<EXPSIZE32> &a)
    {
       unsigned int i = 0;
       unsigned int quotient = 0;
       a = "00000000";
       while(ii > 0)
       {
         quotient = ii % EXPO;
         ii /= EXPO;
         if(quotient == 1 ) a[i] = "1";
         i += 1;
       }
    }

   unsigned int intpower2(unsigned int pwr)
   {
     unsigned int powervalue = 1;
     unsigned int i = 0;

     while(i < pwr)
     {
       powervalue *= EXPO;
       i++;
     }
     return powervalue;
   }

   int bv8_2int(sc_dt::sc_bv<EXPSIZE32> &a)
   {
     unsigned int i = 0;
     unsigned int pwr2 = 0;
     
     for(i = 0; i < EXPSIZE32; i++)
     {
       if(a(i,i) == "1") pwr2 += intpower2(i);
     }

     return pwr2;
   }
     
   void readinput()
   {
     exponent0 = exponentin0.read();
     exponent1 = exponentin1.read();
     significand0 = significandin0.read();
     significand1 = significandin1.read();
     sign0 = signin0.read();
     sign1 = signin1.read();
   }

   void twocomplement(sc_dt::sc_bv<MAXFRBITS32> &a)
   {
     sc_dt::sc_bv<MAXFRBITS32> tmp0; 
     sc_dt::sc_bv<1> tmp1;
     sc_dt::sc_bv<1> carrybit; 
     unsigned int i;
     
     tmp0(MAXFRBITS32 - 1, 0) = a(MAXFRBITS32 - 1, 0);
     tmp0 = ~tmp0;
     
     for(i = 0; i < MAXFRBITS32; i++)
     {
       tmp1 = tmp0(i,i);
       if(i == 0)
       {
         if(tmp1(0,0) == "1") { carrybit = "1"; tmp0(0,0) = "0"; } 
         else if(tmp1(0,0) == "0"){ carrybit = "0"; tmp0(0,0) = "1"; }
       }
       else
       {
         if(tmp1(0,0) == "1" && carrybit == "1") 
            { carrybit = "1"; tmp0(i,i) = "0"; } 
         else if(tmp1(0,0) == "0" && carrybit == "1") 
            { carrybit = "0"; tmp0(i,i) = "1"; }
         else if(tmp1(0,0) == "1" && carrybit == "0")
            { carrybit = "0"; tmp0(i,i) = "1"; }
         else if(tmp1(0,0) == "0" && carrybit == "0")
            { carrybit = "0"; tmp0(i,i) = "0"; }
       }
     }
     a(MAXFRBITS32 - 1, 0) = tmp0(MAXFRBITS32 - 1, 0);    
   }

   void multadd(sc_dt::sc_bv<MAXFRBITS32M> &a,
                sc_dt::sc_bv<MAXFRBITS32M> &b,
                sc_dt::sc_bv<1> &c)
   {
     sc_dt::sc_bv<1> tmp0 = "0";
     sc_dt::sc_bv<1> tmp1 = "0";
     sc_dt::sc_bv<1> tmp2 = "0";

     tmp2(0, 0) = c(0, 0);

     unsigned int i = 0;
     for(i = 0; i < MAXFRBITS32M; i++)
     {
       tmp0 = a(i, i);
       tmp1 = b(i, i);
      
       if(tmp0 == "1" && tmp1 == "1" && tmp2 == "1")
       { a(i, i) = "1"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "1" && tmp1 == "1" && tmp2 == "0")
       { a(i, i) = "0"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "0" && tmp1 == "1" && tmp2 == "1")
       { a(i, i) = "0"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "0" && tmp1 == "1" && tmp2 == "0")
       { a(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "1" && tmp1 == "0" && tmp2 == "1")
       { a(i, i) = "0"; tmp2(0, 0) = "1"; } 
       else if(tmp0 == "1" && tmp1 == "0" && tmp2 == "0")
       { a(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "0" && tmp1 == "0" && tmp2 == "1")
       { a(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "0" && tmp1 == "0" && tmp2 == "0")
       { a(i, i) = "0"; tmp2(0, 0) = "0"; } 
     }      
     c(0, 0) = tmp2(0, 0);
   }

   void subadd(sc_dt::sc_bv<MAXFRBITS32> &a,
               sc_dt::sc_bv<MAXFRBITS32> &b,
               sc_dt::sc_bv<MAXFRBITS32> &r,
               sc_dt::sc_bv<1> &c, bool an, bool bn)
   {
     sc_dt::sc_bv<1> tmp0 = "0";
     sc_dt::sc_bv<1> tmp1 = "0";
     sc_dt::sc_bv<1> tmp2 = "0";

     if(an == false && bn == false)  twocomplement(b);  

     tmp2(0, 0) = c(0, 0);
     std::cout<<a<<" "<<b<<std::endl;
     unsigned int i = 0;
     for(i = 0; i < MAXFRBITS32; i++)
     {
       tmp0 = a(i, i);
       tmp1 = b(i, i);
      
       if(tmp0 == "1" && tmp1 == "1" && tmp2 == "1")
       { r(i, i) = "1"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "1" && tmp1 == "1" && tmp2 == "0")
       { r(i, i) = "0"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "0" && tmp1 == "1" && tmp2 == "1")
       { r(i, i) = "0"; tmp2(0, 0) = "1"; }
       else if(tmp0 == "0" && tmp1 == "1" && tmp2 == "0")
       { r(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "1" && tmp1 == "0" && tmp2 == "1")
       { r(i, i) = "0"; tmp2(0, 0) = "1"; } 
       else if(tmp0 == "1" && tmp1 == "0" && tmp2 == "0")
       { r(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "0" && tmp1 == "0" && tmp2 == "1")
       { r(i, i) = "1"; tmp2(0, 0) = "0"; } 
       else if(tmp0 == "0" && tmp1 == "0" && tmp2 == "0")
       { r(i, i) = "0"; tmp2(0, 0) = "0"; } 
     }      
     c(0, 0) = tmp2(0, 0);
   }

   void normalize(sc_dt::sc_bv<MAXFRBITS32> &a, 
                  sc_dt::sc_bv<EXPSIZE32> &ee,
                  sc_dt::sc_bv<2> &c)
   {
     sc_dt::sc_bv<MAXFRBITS32> tmp0;
     sc_dt::sc_bv<MAXFRBITS32> tmp00 = "000000000000000000000000";
     sc_dt::sc_bv<2> tmp1;
     int tmpexp = 0;
     tmp0 = a;
     tmp1 = c;

     if(tmp1 == "11")
     {
       tmpexp = bv8_2int(ee) - 127;
       tmpexp += 128;
       tmp1(1, 1) = "0";
       tmp1(0, 0) = "1";
       tmp00(MAXFRBITS32 - 1, 0) = tmp0(MAXFRBITS32 - 1, 0);
       tmp0(MAXFRBITS32 - 2, 0) = tmp00(MAXFRBITS32 - 1, 1);
       tmp0(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "0";
       decexp2bin((unsigned int)tmpexp, ee);
     }
     else if(tmp1 == "10")
     {
       /*tmpexp = bv8_2int(ee) - 127;
       tmpexp += 128; */
       tmp1(1, 1) = "0";
       tmp1(0, 0) = "1";
       /*
       tmp00(MAXFRBITS32 - 1, 0) = tmp0(MAXFRBITS32 - 1, 0);
       tmp0(MAXFRBITS32 - 2, 0) = tmp00(MAXFRBITS32 - 1, 1);
       tmp0(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "0";
       decexp2bin((unsigned int)tmpexp, ee); */
     }
     
     a(MAXFRBITS32 - 1, 0) = tmp0(MAXFRBITS32 - 1, 0);
     c(1, 0) = tmp1(1, 0);
   }

   void checkmagnitude(sc_dt::sc_bv<MAXFRBITS32> &a,
                       sc_dt::sc_bv<MAXFRBITS32> &b,
                       sc_dt::sc_bv<EXPSIZE32> &c,
                       sc_dt::sc_bv<1> &hb0,
                       sc_dt::sc_bv<1> &hb1,
                       bool &boo)
   {
     sc_dt::sc_bv<EXPSIZE32> tmpexp;;
     sc_dt::sc_bv<1> tmp0;
     sc_dt::sc_bv<1> tmp1;

     char tmpnum0[10];
     char tmpnum1[10];
     float fa = 0;
     float fb = 0;
     int ia = 0;
     int ib = 0;
      
     unsigned int i        = 0;
     unsigned int pw2      = 0;
     unsigned int expvalue = 0;
     unsigned int hb0value = 0;
     unsigned int hb1value = 0;

     tmpnum0[0] = '\0';
     tmpnum1[0] = '\0';
     tmpexp(EXPSIZE32 - 1, 0) = c(EXPSIZE32 - 1, 0);
    
    
     for(; i < MAXFRBITS32; i++)
     {
       tmp0 = a(i, i);
       tmp1 = b(i, i);
       
       if(tmp0(0, 0) == "1" && tmp1 == "0") ia += intpower2(i);
       else if(tmp0(0, 0) == "0" && tmp1 == "1") ib += intpower2(i);
       else if(tmp0(0, 0) == "1" && tmp1 == "1")
       {
         pw2 = intpower2(i); ia += pw2; ib += pw2; 
       }
     }
     hb0value = hb0(0, 0) == "1" ? 1 : 0;
     hb1value = hb1(0, 0) == "1" ? 1 : 0;
     sprintf(tmpnum0, "%d%s%d", hb0value, ".", ia);
     sprintf(tmpnum1, "%d%s%d", hb1value, ".", ib); 
     expvalue = bv8_2int(tmpexp) - 127;
     fa = strtof(tmpnum0, NULL);
     fb = strtof(tmpnum1, NULL);
     fa *= (float)intpower2(expvalue);
     fb *= (float)intpower2(expvalue);
     boo = fa > fb ? true : false;
     std::cout<<expvalue<<" "<<fa<<" "<<fb<<" "<<boo<<std::endl;
   } 
       
   void checkexponentandshift(sc_dt::sc_bv<MAXFRBITS32> &a,
                              sc_dt::sc_bv<MAXFRBITS32> &b,
                              sc_dt::sc_bv<EXPSIZE32> &ae,
                              sc_dt::sc_bv<EXPSIZE32> &be, 
                              sc_dt::sc_bv<EXPSIZE32> &ee, 
                              sc_dt::sc_bv<1> &c, 
                              sc_dt::sc_bv<1> &d, 
                              unsigned int ui)
   {
     if(ui == 1 || ui == 2)
     {
      sc_dt::sc_bv<MAXFRBITS32> tmpsignificand;
      int pwr0 = bv8_2int(ae) - 127;
      int pwr1 = bv8_2int(be) - 127; 
      int shiftlen = abs(pwr0 - pwr1);
      /* std::cout<<"START "<<a<<" "<<b<<std::endl; */
      if(sign0(0, 0) == "0" && sign1(0, 0) == "0")
      {
       if(pwr1 < pwr0)
       {
        /* std::cout<<"ZERO "<<pwr0<<" "<<pwr1<<" "<<std::endl; */
         tmpsignificand = "00000000000000000000000";
         tmpsignificand(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "1";
         tmpsignificand(MAXFRBITS32 - 2, 0) = b(MAXFRBITS32 - 1, 1);
         shiftlen -= 1;
         tmpsignificand = tmpsignificand >> shiftlen;
         b(MAXFRBITS32 - 1, 0) = tmpsignificand(MAXFRBITS32 - 1, 0);
         ee(EXPSIZE32 - 1, 0) = ae(EXPSIZE32 - 1, 0);
         c(0, 0) = "1";
         d(0, 0) = "0"; 
        /* std::cout<<name()<<" "<<tmpsignificandout<<" "<<b<<std::endl; */  
       }
       else
       {
        /* std::cout<<"ONE " <<pwr0<<" "<<pwr1<<" "<<std::endl; */
         tmpsignificand = "00000000000000000000000";
         tmpsignificand(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "1";
         tmpsignificand(MAXFRBITS32 - 2, 1) = b(MAXFRBITS32 - 2, 1);
         shiftlen -= 1;
         tmpsignificand = tmpsignificand >> shiftlen;
         a(MAXFRBITS32 - 1, 0) = tmpsignificand(MAXFRBITS32 - 1, 0);
         ee(EXPSIZE32 - 1, 0) = be(EXPSIZE32 - 1, 0);
        /* std::cout<<name()<<" "<<tmpsignificandout<<" "<<a<<std::endl; */ 
         c(0, 0) = "0";
         d(0, 0) = "1";  
       }
      }
      else
      {
        if(pwr1 < pwr0)
        {
        /* std::cout<<"TWO " <<pwr0<<" "<<pwr1<<" "<<std::endl; */
          tmpsignificand = "00000000000000000000000";
          tmpsignificand(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "1";
          tmpsignificand(MAXFRBITS32 - 2, 1) = b(MAXFRBITS32 - 2, 1);
          shiftlen -= 1;
          tmpsignificand = tmpsignificand >> shiftlen;
          b(MAXFRBITS32 - 1, 0) = tmpsignificand(MAXFRBITS32 - 1, 0);
          ee(EXPSIZE32 - 1, 0) = ae(EXPSIZE32 - 1, 0); 
          c(0, 0) = "1";
          d(0, 0) = "0";  
        }
        else
        {
        /* std::cout<<"THREE " <<pwr0<<" "<<pwr1<<" "<<std::endl; */
          tmpsignificand = "00000000000000000000000";
          tmpsignificand(MAXFRBITS32 - 1, MAXFRBITS32 - 1) = "1";
          tmpsignificand(MAXFRBITS32 - 2, 1) = b(MAXFRBITS32 - 2, 1);
          shiftlen -= 1;
          tmpsignificand = tmpsignificand >> shiftlen;
          a(MAXFRBITS32 - 1, 0) = tmpsignificand(MAXFRBITS32 - 1, 0);  
          ee(EXPSIZE32 - 1, 0) = be(EXPSIZE32 - 1, 0);
          c(0, 0) = "0";
          d(0, 0) = "1"; 
        } 
        if(sign0(0, 0) == "1" && sign1(0, 0) == "0") { twocomplement(a);}
        else if(sign0(0, 0) == "0" && sign1(0, 0) == "1") { twocomplement(b);}
        else if(sign0(0, 0) == "1" && sign1(0, 0) == "1") 
        { 
          twocomplement(a); 
          twocomplement(b); 
        }  
      }
      exponentcheck = true;
      /* std::cout<<"END "<<a<<" "<<b<<std::endl; */
     }
   }

   
   void add(sc_dt::sc_bv<MAXFRBITS32> &a, 
            sc_dt::sc_bv<MAXFRBITS32> &b,
            sc_dt::sc_bv<MAXFRBITS32> &r,
            sc_dt::sc_bv<EXPSIZE32> &ee,
            sc_dt::sc_bv<1> &c, 
            sc_dt::sc_bv<1> &cb,
            sc_dt::sc_bv<1> &d, 
            sc_dt::sc_bv<2> &e)
   {
     sc_dt::sc_bv<1> tmp0;
     sc_dt::sc_bv<1> tmp1;
     unsigned int i = 0;
     r = "00000000000000000000000";
     cb = "0";

     if(exponentcheck == true)
     {
       for(i = 0; i < MAXFRBITS32; i++)
       {
         tmp0 = a(i,i);
         tmp1 = b(i,i);
         if(i == 0) 
         {
           if(tmp0 == "0" && tmp1 == "1") 
           { cb = 0; r(i,i) = "1"; }
           else if(tmp0 == "1" && tmp1 == "0") 
           { cb = 0; r(i,i) = "1"; }
           else if(tmp0 == "1" && tmp1 == "1") 
           { cb = 1; r(i,i) = "0"; }
         }
         else
         {
           if(tmp0 == "0" && tmp1 == "0" && carrybit == "0") 
           { cb = 0; r(i,i) = "0"; }
           else if(tmp0 == "0" && tmp1 == "0" && carrybit == "1") 
           { cb = 0; r(i,i) = "1"; }
           else if(tmp0 == "0" && tmp1 == "1" && carrybit == "0") 
           { cb = 0; r(i,i) = "1"; }
           else if(tmp0 == "1" && tmp1 == "0" && carrybit == "0") 
           { cb = 0; r(i,i) = "1"; }
           else if(tmp0 == "0" && tmp1 == "1" && carrybit == "1") 
           { cb = 1; r(i,i) = "0"; }
           else if(tmp0 == "1" && tmp1 == "0" && carrybit == "1") 
           { cb = 1; r(i,i) = "0"; }
           else if(tmp0 == "1" && tmp1 == "1" && carrybit == "0") 
           { cb = 1; r(i,i) = "0"; }
           else if(tmp0 == "1" && tmp1 == "1" && carrybit == "1") 
           { cb = 1; r(i,i) = "1"; }
         }
       }
       if(cb(0, 0) == "1" && c(0, 0) == "1" && d == "1") e = "11"; 
       else if(cb(0, 0) == "1" && c(0, 0) == "1" && d == "0") e = "10"; 
       else if(cb(0, 0) == "1" && c(0, 0) == "0" && d == "1") e = "10"; 
       else if(cb(0, 0) == "0" && c(0, 0) == "1" && d == "1") e = "10";
       else if(cb(0, 0) == "0" && c(0, 0) == "0" && d == "1") e = "01"; 
       else if(cb(0, 0) == "0" && c(0, 0) == "1" && d == "0") e = "01"; 
       else if(cb(0, 0) == "1" && c(0, 0) == "0" && d == "0") e = "01"; 
       else if(cb(0, 0) == "0" && c(0, 0) == "0" && d == "0") e = "00";
       normalize(r, ee, e);  
       std::cout<<name()<<" "<<cb<<" "<<c<<" "<<d<<" "<<e<<" "<<ee<<" "<<r<<std::endl;
     }    
   }  
    
   void mult(sc_dt::sc_bv<MAXFRBITS32> &a, 
            sc_dt::sc_bv<MAXFRBITS32> &b,
            sc_dt::sc_bv<EXPSIZE32> &c,
            sc_dt::sc_bv<EXPSIZE32> &d,
            sc_dt::sc_bv<1> &e,
            sc_dt::sc_bv<1> &f,
            sc_dt::sc_bv<MAXFRBITS32M> &r,
            sc_dt::sc_bv<EXPSIZE32> &ef,
            sc_dt::sc_bv<MAXFRBITS32> &sf,
            sc_dt::sc_bv<1> &sif)
   {
     sc_dt::sc_bv<MAXFRBITS32>  tmp0;
     sc_dt::sc_bv<MAXFRBITS32>  tmp1;
     sc_dt::sc_bv<MAXFRBITS32P> tmp2;
     sc_dt::sc_bv<MAXFRBITS32P> tmp3;
     sc_dt::sc_bv<MAXFRBITS32M> tmp4;
     sc_dt::sc_bv<MAXFRBITS32M> tmp5;
     sc_dt::sc_bv<EXPSIZE32>    tmp6;
     sc_dt::sc_bv<EXPSIZE32>    tmp7; 
     sc_dt::sc_bv<1> tmp;
     sc_dt::sc_bv<1> mcarry;
     int expf;
     unsigned int i; 

     tmp0 = "00000000000000000000000";
     tmp1 = "00000000000000000000000";
     tmp2 = "000000000000000000000000";
     tmp3 = "000000000000000000000000";
     tmp4 = "000000000000000000000000000000000000000000000000";
     tmp5 = "000000000000000000000000000000000000000000000000";
     mcarry = "0";

     tmp0(MAXFRBITS32 - 1, 0) = a(MAXFRBITS32 - 1, 0);
     tmp1(MAXFRBITS32 - 1, 0) = b(MAXFRBITS32 - 1, 0);
     tmp2(MAXFRBITS32P - 1, MAXFRBITS32P - 1) = "1";
     tmp3(MAXFRBITS32P - 1, MAXFRBITS32P - 1) = "1";
     tmp2(MAXFRBITS32P - 2, 0) = tmp0(MAXFRBITS32 - 1, 0);
     tmp3(MAXFRBITS32P - 2, 0) = tmp1(MAXFRBITS32 - 1, 0);
     tmp4(MAXFRBITS32P - 1, 0) = tmp2(MAXFRBITS32P - 1, 0);

     expf = (bv8_2int(c) - 127) + (bv8_2int(d) - 127);
     
     for(i = 0; i < MAXFRBITS32P; i++)
     {
       tmp(0, 0) = tmp3(i, i);

       if(tmp(0, 0) == "0") { if(i > 0) tmp4 = tmp4 << 1;  } 
       else if(tmp(0, 0) == "1")
       {
         tmp4 = tmp4 << 1;
         multadd(tmp5, tmp4, mcarry);
       }
     }
     if(tmp5(MAXFRBITS32M - 1, MAXFRBITS32M - 1) == "0") tmp5 = tmp5 << 1;
     expf += 127;
     decexp2bin((unsigned int)expf, ef);
     if(e(0, 0) == "0" && f(0, 0) == "1") sif(0, 0) = "1";
     else if(e(0, 0) == "1" && f(0, 0) == "0") sif(0, 0) = "1";
     else if(e(0, 0) == "1" && f(0, 0) == "1") sif(0, 0) = "0";
     else if(e(0, 0) == "0" && f(0, 0) == "0") sif(0, 0) = "0";
     r(MAXFRBITS32M - 1, 0) = tmp5(MAXFRBITS32M - 1, 0); 
     sf(MAXFRBITS32 - 1, 0) = tmp5(MAXFRBITS32M - 2, MAXFRBITS32M - 24);
     
  } 
   
  void sub(sc_dt::sc_bv<MAXFRBITS32> &a, 
           sc_dt::sc_bv<MAXFRBITS32> &b,
           sc_dt::sc_bv<EXPSIZE32> &c,
           sc_dt::sc_bv<1> &e,
           sc_dt::sc_bv<1> &f,
           sc_dt::sc_bv<1> &cb,
           sc_dt::sc_bv<1> &hb0,
           sc_dt::sc_bv<1> &hb1,
           sc_dt::sc_bv<2> &hbs,
           sc_dt::sc_bv<EXPSIZE32> &ef,
           sc_dt::sc_bv<MAXFRBITS32> &sf,
           sc_dt::sc_bv<1> &sif)
   {
      bool aneg = false;
      bool bneg = false;
      bool boo  = false;
      
      if(exponentcheck == true)
      {
        if(e(0, 0) == "1" && f(0, 0) == "0") aneg = true;
        else if(e(0, 0) == "0" && f(0, 0) == "1") bneg = true;
        else if(e(0, 0) == "1" && f(0, 0) == "1") 
        { aneg = true; bneg = true; }
        
        checkmagnitude(a, b, c, hb0, hb1, boo);

        if(boo == true && aneg == true && bneg == false)        sif = "1";
        else if(boo == false && aneg == true && bneg == false)  sif = "1";
        else if(boo == true && aneg == false && bneg == true)   sif = "0";
        else if(boo == false && aneg == false && bneg == true)  sif = "1";
        else if(boo == true && aneg == false && bneg == false)  sif = "0";
        else if(boo == false && aneg == false && bneg == false) sif = "1";
        else if(boo == false && aneg == true && bneg == true)   sif = "0";
        else if(boo == true && aneg == true && bneg == true)    sif = "1";
        subadd(a, b, sf, cb, aneg, bneg);
        std::cout<<cb<<" "<<hb0<<" "<<hb1<<std::endl;
        if(cb(0, 0) == "1" && hb0(0, 0) == "1" && hb1 == "1") hbs = "11"; 
        else if(cb(0, 0) == "1" && hb0(0, 0) == "1" && hb1 == "0") hbs = "10"; 
        else if(cb(0, 0) == "1" && hb0(0, 0) == "0" && hb1 == "1") hbs = "10"; 
        else if(cb(0, 0) == "0" && hb0(0, 0) == "1" && hb1 == "1") hbs = "10";
        else if(cb(0, 0) == "0" && hb0(0, 0) == "0" && hb1 == "1") hbs = "01"; 
        else if(cb(0, 0) == "0" && hb0(0, 0) == "1" && hb1 == "0") hbs = "01"; 
        else if(cb(0, 0) == "1" && hb0(0, 0) == "0" && hb1 == "0") hbs = "01"; 
        else if(cb(0, 0) == "0" && hb0(0, 0) == "0" && hb1 == "0") hbs = "00";
        normalize(sf, c, hbs);
        std::cout<<sif<<" "<<c<<" "<<sf<<std::endl;
      }
   }  

  public:
   sc_core::sc_in< sc_dt::sc_bv<MAXFRBITS32> > significandin0;
   sc_core::sc_in< sc_dt::sc_bv<MAXFRBITS32> > significandin1;
   sc_core::sc_in< sc_dt::sc_bv<EXPSIZE32> > exponentin0;
   sc_core::sc_in< sc_dt::sc_bv<EXPSIZE32> > exponentin1;
   sc_core::sc_in< sc_dt::sc_bv<1> > signin0;
   sc_core::sc_in< sc_dt::sc_bv<1> > signin1;

   sc_dt::sc_bv<MAXFRBITS32 + EXPSIZE32> num0;
   sc_dt::sc_bv<MAXFRBITS32 + EXPSIZE32> num1;
   sc_dt::sc_bv<MAXFRBITS32M> multresf;
   sc_dt::sc_bv<MAXFRBITS32> significand0;
   sc_dt::sc_bv<MAXFRBITS32> significand1;
   sc_dt::sc_bv<MAXFRBITS32> significandresadd;
   sc_dt::sc_bv<MAXFRBITS32> significandresmult;
   sc_dt::sc_bv<MAXFRBITS32> significandressub;
   sc_dt::sc_bv<EXPSIZE32> exponent0;
   sc_dt::sc_bv<EXPSIZE32> exponent1;
   sc_dt::sc_bv<EXPSIZE32> nexponent;
   sc_dt::sc_bv<EXPSIZE32> mexponent;
   sc_dt::sc_bv<EXPSIZE32> sexponent;
   sc_dt::sc_bv<1> sign0;
   sc_dt::sc_bv<1> sign1;
   sc_dt::sc_bv<1> signadd;
   sc_dt::sc_bv<1> signmult;
   sc_dt::sc_bv<1> signsub;
   sc_dt::sc_bv<1> carrybit;
   sc_dt::sc_bv<1> hiddenbit0;
   sc_dt::sc_bv<1> hiddenbit1;
   sc_dt::sc_bv<2> hiddenbits;
   bool exponentcheck;
   unsigned int oper;

   void ieee754_32_arithmetic_all_bin_proc0()
   {
     while(1)
     {
       wait();
       readinput();
       checkexponentandshift(significand0, 
                             significand1,
                             exponent0,
                             exponent1, 
                             nexponent,
                             hiddenbit0, 
                             hiddenbit1, oper);
       if(oper == 1)
       {                 add(significand0, 
                         significand1, 
                         significandresadd,
                         nexponent,
                         hiddenbit0, 
                         carrybit,
                         hiddenbit1, 
                         hiddenbits);
       }
       else if(oper == 2) 
       {
                              sub(significand0, 
                              significand1,
                              nexponent,
                              sign0,
                              sign1,
                              carrybit,
                              hiddenbit0,
                              hiddenbit1,
                              hiddenbits,
                              sexponent,
                              significandressub,
                              signsub);
      } 
      else if(oper == 3) 
      { 
                              mult(significand0, 
                              significand1,
                              exponent0,
                              exponent1,
                              sign0,
                              sign1,
                              multresf,
                              mexponent,
                              significandresmult,
                              signmult); 
      std::cout<<signmult<<" "<<mexponent<<" "<<significandresmult<<std::endl;
      }
     }
   }

   SC_CTOR(ieee754_32_arithmetic_all_bin): num0("0000000000000000000000000000000"),
                                           num1("0000000000000000000000000000000"),
                                   significandresadd("00000000000000000000000"),
                                   significandresmult("00000000000000000000000"),
                                   significandressub("00000000000000000000000"),
                                   significand0("00000000000000000000000"),
                                   significand1("00000000000000000000000"),
                      multresf("0000000000000000000000000000000000000000000000000"),
                                   exponent0("00000000"),
                                   exponent1("00000000"),
                                   nexponent("00000000"),
                                   mexponent("00000000"),
                                   sexponent("00000000"),
                                   carrybit("0"),
                                   sign0("0"), 
                                   sign1("0"),
                                   signadd("0"), 
                                   signmult("0"),
                                   signsub("0"),
                                   hiddenbit0("0"), 
                                   hiddenbit1("0"),
                                   exponentcheck(false), oper(0)
   {
     SC_THREAD(ieee754_32_arithmetic_all_bin_proc0);
     sensitive << exponentin0 << exponentin1 << significandin0 << significandin1 << signin0 << signin1;
   }

   ~ieee754_32_arithmetic_all_bin(){ }
};
   
SC_MODULE(ieee754_32_arithmetic_all)
{
  private:
    void decfr2bin(float ff, sc_dt::sc_bv<MAXFRBITS32> &a)
    {
      unsigned int j = 0;
      float decrement = 0.0;
      float tmp0 = 0.0;

      a = "00000000000000000000000";

      ff = fabs(ff);
      for(j = 0; j < MAXFRBITS32; j++)
      {
        if(ff < 1.0)
        {
          tmp0 = EXPO*ff;
          if(tmp0 >= 1.0)
          {  
            a[j] = "1";
            tmp0 -= 1.0;
          }
          ff = tmp0;
        } 
      }
    }
    
    void decexp2bin(unsigned int ii, sc_dt::sc_bv<EXPSIZE32> &a)
    {
       unsigned int i = 0;
       unsigned int quotient = 0;
       a = "00000000";
       while(ii > 0)
       {
         quotient = ii % EXPO;
         ii /= EXPO;
         if(quotient == 1 ) a[i] = "1";
         i += 1;
       }
    }

    int biggestpower2(float ff, sc_dt::sc_bv<1> &a)
    {
      int power_2_value    = 1;
      int power_2_exponent = 0;
      float power_2_value_ltz = 1.0;
      float ffabs = fabs(ff);

      if(ff < 0.0) a = "1";
      else a = "0";

      if(ffabs > 1.0)
      {
        while((float)power_2_value < ffabs)
        {
          power_2_value *= EXPO;
          power_2_exponent += 1;
        }
      }
      else if(ffabs > 0.0 && ffabs < 1.0)
      {
         while(power_2_value_ltz > ffabs)
         {
           power_2_value_ltz /= EXPO;
           power_2_exponent -= 1;
         }
      }
      if(power_2_exponent > 0) return (power_2_exponent - 1);
      else if(power_2_exponent < 0) return power_2_exponent;
    }

       
    float power2(int ii)
    {
      float power_2_value = 1;
      unsigned int i = 0;
      if(ii > 0)
      {
        for(i = 0; i < ii; i++) power_2_value *= EXPO;
      }
      else
      {
        for(i = 0; i < abs(ii); i++) power_2_value /= EXPO;
      }    
      return power_2_value;
    }

  public:
   sc_core::sc_in<float> floatin0;
   sc_core::sc_in<float> floatin1;
   sc_core::sc_in< sc_dt::sc_bv<EXPO> > operin;
   sc_core::sc_out< sc_dt::sc_bv<EXPSIZE32> > exponentout0;
   sc_core::sc_out< sc_dt::sc_bv<MAXFRBITS32> > significandout0;
   sc_core::sc_out< sc_dt::sc_bv<1> > signout0;
   
   float num0;
   float num1;
   float result;
   float convfloat0; 
   int exponentvalue0; 
   sc_dt::sc_bv<MAXFRBITS32> significandvalue0;
   sc_dt::sc_bv<EXPSIZE32> exponentbinvalue0;
   sc_dt::sc_bv<EXPO> opervalue;
   sc_dt::sc_bv<1> signbit0;
  
   
   void ieee754_32_arithmetic_all_proc0()
   {
     while(1)
     {
       wait();
       num0 = floatin0.read();
       num1 = floatin1.read();
       opervalue = operin.read();
       if(opervalue == "00") result = num0 + num1;
       else if(opervalue == "01") result = num0 - num1;
       else if(opervalue == "10") result = num0 * num1;
       else if(opervalue == "11") result = num0/num1;

       exponentvalue0 = biggestpower2(result, signbit0);
       convfloat0 = result/power2((float)exponentvalue0); 
       if(convfloat0 > 1.0) convfloat0 -= 1.0;
       else if(convfloat0 < 0.0) convfloat0 += 1.0;
       exponentvalue0 += 127;
       decfr2bin(convfloat0, significandvalue0);
       decexp2bin(exponentvalue0, exponentbinvalue0);
       exponentout0.write(exponentbinvalue0);
       significandout0.write(significandvalue0);
       signout0.write(signbit0);
       std::cout<<name()<<" "<<result<<" "<<exponentbinvalue0<<" "<<significandvalue0<<std::endl;
     }
   }

   SC_CTOR(ieee754_32_arithmetic_all): num0(0.0), 
                                       num1(0.0), 
                                       result(0.0)
   {
     SC_THREAD(ieee754_32_arithmetic_all_proc0);
     sensitive << floatin0 << floatin1 << operin;
   }
   
   ~ieee754_32_arithmetic_all(){ }
};
   
   

SC_MODULE(ieee754_32_2dec_conv)
{
  private:
   float fpower2(int ii)
   {
     float outvalue = 1.0;
     unsigned int i = 0;

     if(ii > 0)
       for(i = 0; i < ii; i++) outvalue *= EXPO;
     else
       for(i = 0; i < abs(ii); i++) outvalue /= EXPO;
     
     return outvalue;
   }
     

   unsigned int intpower2(unsigned int i)
   {
     unsigned int j = 0;
     unsigned int outvalue = 1;
     
     for(j = 0; j  <  i; j++) outvalue *= EXPO;
     return outvalue;
   }
 
   unsigned int binexp2biasdec(sc_dt::sc_bv<EXPSIZE32> &a)
   {
     sc_dt::sc_bv<1> tmp0;
     unsigned int outvalue = 0;
     unsigned int j;
  
     for(j = 0; j < EXPSIZE32; j++) 
     {
       tmp0 = a(j,j);
       if(tmp0 == "1") outvalue += intpower2(j);  
     }
     return outvalue;
   }
       
   unsigned int binsig2decfr(sc_dt::sc_bv<MAXFRBITS32> &a)
   {
     sc_dt::sc_bv<1> tmp0;
     unsigned int outvalue = 0;
     unsigned int j;
  
     for(j = MAXFRBITS32 - 1 ; j > 0; j--) 
     {
       tmp0 = a(j,j);
       if(tmp0 == "1") 
       {
         outvalue += intpower2(MAXFRBITS32 - 1 - j);
         /* std::cout<<name()<<" "<<j<<" "<<intpower2(j)<<std::endl; */
       }  
     }
     return outvalue;
   }

  public:
   sc_core::sc_in< sc_dt::sc_bv<EXPSIZE32> > exponentin;
   sc_core::sc_in< sc_dt::sc_bv<MAXFRBITS32> > significandin;
   sc_core::sc_in< sc_dt::sc_bv<1> > signbitin;
   /*sc_core::sc_out<float> numberout;
   sc_core::sc_out<int> exponentout;*/

   sc_dt::sc_bv<EXPSIZE32> exponentvalue;
   sc_dt::sc_bv<MAXFRBITS32> significandvalue;
   sc_dt::sc_bv<1> signbit;

   char numstr[10];
   int exponentoutvalue;
   int frsignificandoutvalue;
   float flnum;
   
   void ieee754_32_2dec_conv_proc0()
   {
     while(1)
     {
       wait();
       exponentvalue = exponentin.read();
       significandvalue = significandin.read();
       signbit = signbitin.read();
       exponentoutvalue = binexp2biasdec(exponentvalue) - 127;
       frsignificandoutvalue = binsig2decfr(significandvalue);
       sprintf(numstr, "%s.%d%s", "1",frsignificandoutvalue,"\0");
       flnum = strtof(numstr, NULL)*fpower2(exponentoutvalue);
       std::cout<<name()<<" "<<signbit<<" "<<exponentoutvalue<<" "<<frsignificandoutvalue<<" "<<numstr<<" "<<flnum<<std::endl; 
     }
   }

   SC_CTOR(ieee754_32_2dec_conv):exponentvalue("00000000"),
                            significandvalue("00000000000000000000000"),
                            exponentoutvalue(0),frsignificandoutvalue(0)
   {
     SC_THREAD(ieee754_32_2dec_conv_proc0);
     sensitive << exponentin << significandin << signbitin;
   }

   ~ieee754_32_2dec_conv(){ }
};


SC_MODULE(dec2ieee754_32_conv)
{
  private:
    void decfr2bin(float ff, sc_dt::sc_bv<MAXFRBITS32> &a)
    {
      unsigned int j = 0;
      float decrement = 0.0;
      float tmp0 = 0.0;

      a = "00000000000000000000000";

      ff = fabs(ff);
      for(j = 0; j < MAXFRBITS32; j++)
      {
        if(ff < 1.0)
        {
          tmp0 = EXPO*ff;
          if(tmp0 >= 1.0)
          {  
            a[MAXFRBITS32 - 1 - j] = "1";
            tmp0 -= 1.0;
          }
          ff = tmp0;
        } 
      }
    }
    
    void decexp2bin(unsigned int ii, sc_dt::sc_bv<EXPSIZE32> &a)
    {
       unsigned int i = 0;
       unsigned int quotient = 0;
       a = "00000000";
       while(ii > 0)
       {
         quotient = ii % EXPO;
         ii /= EXPO;
         if(quotient == 1 ) a[i] = "1";
         i += 1;
       }
    }

    int biggestpower2(float ff, sc_dt::sc_bv<1> &a)
    {
      int power_2_value    = 1;
      int power_2_exponent = 0;
      float power_2_value_ltz = 1.0;
      float ffabs = fabs(ff);

      if(ff < 0.0) a = "1";
      else a = "0";

      if(ffabs > 1.0)
      {
        while((float)power_2_value < ffabs)
        {
          power_2_value *= EXPO;
          power_2_exponent += 1;
        }
      }
      else if(ffabs > 0.0 && ffabs < 1.0)
      {
         while(power_2_value_ltz > ffabs)
         {
           power_2_value_ltz /= EXPO;
           power_2_exponent -= 1;
         }
      }
      if(power_2_exponent > 0) return (power_2_exponent - 1);
      else if(power_2_exponent < 0) return power_2_exponent;
    }

       
    float power2(int ii)
    {
      float power_2_value = 1;
      unsigned int i = 0;
      if(ii > 0)
      {
        for(i = 0; i < ii; i++) power_2_value *= EXPO;
      }
      else
      {
        for(i = 0; i < abs(ii); i++) power_2_value /= EXPO;
      }    
      return power_2_value;
    }
      
  public:
   sc_core::sc_in<float> floatin0;
   sc_core::sc_in<float> floatin1;
   
   sc_core::sc_out< sc_dt::sc_bv<EXPSIZE32> > exponentout0;
   sc_core::sc_out< sc_dt::sc_bv<MAXFRBITS32> > significandout0;
   sc_core::sc_out< sc_dt::sc_bv<1> > signout0;
   sc_core::sc_out< sc_dt::sc_bv<EXPSIZE32> > exponentout1;
   sc_core::sc_out< sc_dt::sc_bv<MAXFRBITS32> > significandout1;
   sc_core::sc_out< sc_dt::sc_bv<1> > signout1;
   
   sc_dt::sc_bv<MAXFRBITS32> significandvalue0;
   sc_dt::sc_bv<EXPSIZE32> exponentbinvalue0;
   sc_dt::sc_bv<MAXFRBITS32> significandvalue1;
   sc_dt::sc_bv<EXPSIZE32> exponentbinvalue1;
   sc_dt::sc_bv<1> signbit0;
   sc_dt::sc_bv<1> signbit1;
   int exponentvalue0; 
   int exponentvalue1; 
   float floatvalue0;
   float convfloat0; 
   float floatvalue1;
   float convfloat1;


   void dec2ieee754_32_conv_proc0()
   {
     while(1)
     {
       wait();
       floatvalue0 = floatin0.read();
       floatvalue1 = floatin1.read();
       exponentvalue0 = biggestpower2(floatvalue0, signbit0);
       exponentvalue1 = biggestpower2(floatvalue1, signbit1);
       convfloat0 = floatvalue0/power2((float)exponentvalue0); 
       convfloat1 = floatvalue1/power2((float)exponentvalue1);
       std::cout<<floatvalue0<<" "<<exponentvalue0<<" "<<convfloat0<<std::endl;
       std::cout<<floatvalue1<<" "<<exponentvalue1<<" "<<convfloat1<<std::endl; 
       if(convfloat0 > 1.0) convfloat0 -= 1.0;
       else if(convfloat0 < 0.0) convfloat0 += 1.0;
       if(convfloat1 > 1.0) convfloat1 -= 1.0;
       else if(convfloat1 < 0.0) convfloat1 += 1.0;
       exponentvalue0 += 127;
       exponentvalue1 += 127;
       decfr2bin(convfloat0, significandvalue0);
       decfr2bin(convfloat1, significandvalue1);
       decexp2bin(exponentvalue0, exponentbinvalue0);
       decexp2bin(exponentvalue1, exponentbinvalue1);
       
       exponentout0.write(exponentbinvalue0);
       significandout0.write(significandvalue0);
       signout0.write(signbit0);
   
       signout1.write(signbit1);
       exponentout1.write(exponentbinvalue1);
       significandout1.write(significandvalue1);
    
       std::cout<<name()<<std::endl;
       std::cout<<" significand 1 "<<significandvalue0<<std::endl;
       std::cout<<" exponent 1  "<<exponentbinvalue0<<std::endl;
       std::cout<<" sign 1 "<<signbit0<<std::endl;
       std::cout<<" significand 2 "<<significandvalue1<<std::endl;
       std::cout<<" exponent 2 "<<exponentbinvalue1<<std::endl;
       std::cout<<" sign 2 "<<signbit1<<std::endl;
       
     }
   }

   SC_CTOR(dec2ieee754_32_conv):exponentbinvalue0("00000000"),
                                exponentbinvalue1("00000000"),
                                significandvalue0("00000000000000000000000"),
                                significandvalue1("00000000000000000000000"),
                                signbit0("0"), signbit1("0")
   {
     SC_THREAD(dec2ieee754_32_conv_proc0);
     sensitive << floatin0 << floatin1;
   }

   ~dec2ieee754_32_conv(){ }
};
 
/*** 64 BIT CODE BELOW */
SC_MODULE(ieee754_64_2dec_conv)
{
  private:
   long double ldpower2(long ii)
   {
     long double outvalue = 1.0;
     unsigned long iiabs = (ii > 0) ? ii : (0 - ii);
     unsigned int i = 0;
    
     if(ii > 0)
       for(i = 0; i < ii; i++) outvalue *= EXPO;
     else
       for(i = 0; i < iiabs; i++) outvalue /= EXPO;
     
     return outvalue;
   }
     

   unsigned long intpower2(int i)
   {
     unsigned int j = 0;
     unsigned long outvalue = 1;
     
     for(j = 0; j  <  i; j++) outvalue *= EXPO;
     return outvalue;
   }
 
   long binexp2biasdec(sc_dt::sc_bv<EXPSIZE64> &a)
   {
     sc_dt::sc_bv<1> tmp0;
     unsigned int outvalue = 0;
     unsigned int j;
     
     for(j = 0; j < EXPSIZE64; j++) 
     {
       tmp0 = a(j,j);
       if(tmp0 == "1") outvalue += intpower2(j);  
     }
     
     return outvalue;
   }
       
   long binsig2decfr(sc_dt::sc_bv<MAXFRBITS64> &a)
   {
     sc_dt::sc_bv<1> tmp0;
     unsigned int outvalue = 0;
     unsigned int j;
  
     for(j = 0; j < MAXFRBITS64; j++) 
     {
       tmp0 = a(j,j);
       if(tmp0 == "1") outvalue += intpower2(j);  
     }
     return outvalue;
   }

  public:
   sc_core::sc_in< sc_dt::sc_bv<EXPSIZE64> > exponentin;
   sc_core::sc_in< sc_dt::sc_bv<MAXFRBITS64> > significandin;
   /*sc_core::sc_out<float> numberout;
   sc_core::sc_out<int> exponentout;*/

   sc_dt::sc_bv<EXPSIZE64> exponentvalue;
   sc_dt::sc_bv<MAXFRBITS64> significandvalue;

   char numstr[10];
   long exponentoutvalue;
   long frsignificandoutvalue;
   long double flnum;
   
   void ieee754_64_2dec_conv_proc0()
   {
     while(1)
     {
       wait();
       exponentvalue = exponentin.read();
       significandvalue = significandin.read();
       exponentoutvalue = binexp2biasdec(exponentvalue) - 1023;
       
       frsignificandoutvalue = binsig2decfr(significandvalue);
       
       sprintf(numstr, "%s.%d%s", "1",frsignificandoutvalue,"\0");
       flnum = strtod(numstr, NULL)*ldpower2(exponentoutvalue);
       std::cout<<exponentoutvalue<<" "<<frsignificandoutvalue<<" "<<numstr<<" "<<flnum<<std::endl;
       
     }
   }

   SC_CTOR(ieee754_64_2dec_conv):exponentvalue("00000000000"),
   significandvalue("0000000000000000000000000000000000000000000000000000"),
   exponentoutvalue(0),frsignificandoutvalue(0)
   {
     SC_THREAD(ieee754_64_2dec_conv_proc0);
     sensitive << exponentin << significandin;
   }

   ~ieee754_64_2dec_conv(){ }
};


SC_MODULE(dec2ieee754_64_conv)
{
  private:
    void decfr2bin(long double ff)
    {
      unsigned int j = 0;
      long double decrement = 0.0;
      long double tmp0 = 0.0;

      significandvalue ="0000000000000000000000000000000000000000000000000000";

      ff = fabs(ff);
      for(j = 0; j < MAXFRBITS64; j++)
      {
        if(ff < 1.0)
        {
          tmp0 = EXPO*ff;
          if(tmp0 >= 1.0)
          {  
            significandvalue[j] = "1";
            tmp0 -= 1.0;
          }
          ff = tmp0;
        } 
      }
    }
    
    void decexp2bin(unsigned int ii)
    {
       unsigned int i = 0;
       unsigned int quotient = 0;
       exponentbinvalue = "00000000000";
       while(ii > 0)
       {
         quotient = ii % EXPO;
         ii /= EXPO;
         if(quotient == 1 ) exponentbinvalue[i] = "1";
         i += 1;
       }
    }

    long biggestpower2(long double ff)
    {
      int power_2_value    = 1;
      int power_2_exponent = 0;
      long double power_2_value_ltz = 1.0;
      long double ldabs = ff > 0.0 ? ff : (0.0 - ff) ;

      if(ff < 0.0) signbit = "1";
      else signbit = "0";

      if(ldabs > 1.0)
      {
        while(power_2_value < ldabs)
        {
          power_2_value *= EXPO;
          power_2_exponent += 1;
        }
      }
      else if(ldabs > 0.0 && ldabs < 1.0)
      {
         while(power_2_value_ltz > ldabs)
         {
           power_2_value_ltz /= EXPO;
           power_2_exponent -= 1;
         }
      }
      if(power_2_exponent > 0) return (power_2_exponent - 1);
      else if(power_2_exponent < 0) return power_2_exponent;
    }

       
    long double power2(long ii)
    {
      long double power_2_value = 1;
      unsigned long i = 0;
      unsigned long iiabs = ii > 0 ? ii : (0 - ii);
      if(ii > 0)
      {
        for(i = 0; i < ii; i++) power_2_value *= EXPO;
      }
      else
      {
        for(i = 0; i < iiabs; i++) power_2_value /= EXPO;
      }    
      return power_2_value;
    }
      
  public:
   sc_core::sc_in<float> ldin;
   sc_core::sc_out< sc_dt::sc_bv<EXPSIZE64> > exponentout;
   sc_core::sc_out< sc_dt::sc_bv<MAXFRBITS64> > significandout;
   
   sc_dt::sc_bv<MAXFRBITS64> significandvalue;
   sc_dt::sc_bv<EXPSIZE32> exponentbinvalue;
   sc_dt::sc_bv<1> signbit;
   long exponentvalue; 
   long double ldvalue;
   long double convld;

   void dec2ieee754_64_conv_proc0()
   {
     while(1)
     {
       wait();
       ldvalue = ldin.read();
       exponentvalue = biggestpower2(ldvalue);
       convld = ldvalue/power2((long double)exponentvalue); 
       std::cout<<ldvalue<<" "<<exponentvalue<<" "<<convld<<std::endl;
       if(convld > 1.0) convld -= 1.0;
       else if(convld < 0.0) convld += 1.0;
       exponentvalue += 1023;
       decfr2bin(convld);
       decexp2bin(exponentvalue);
       exponentout.write(exponentbinvalue);
       significandout.write(significandvalue);
       /*
       std::cout<<name()<<" "<<significandvalue<<std::endl;
       std::cout<<name()<<" "<<exponentbinvalue<<std::endl;
       std::cout<<name()<<" "<<signbit<<std::endl;
       */
     }
   }

   SC_CTOR(dec2ieee754_64_conv)
   {
     SC_THREAD(dec2ieee754_64_conv_proc0);
     sensitive << ldin;
   }

   ~dec2ieee754_64_conv(){ }
};
    
#endif
 
