#ifndef DELSIGBP_H
#define DELSIGBP_H

#include <systemc-ams>

SC_MODULE(elnbndpass60)
{
  sca_tdf::sca_in<double> inp;
  sca_tdf::sca_out<double> outp;

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_c cap0; 
  sca_eln::sca_l indt0; 

  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node_ref gnd;
  
  SC_CTOR(elnbndpass60):v_in("v_in", 1.0), 
                      v_out("v_out", 1.0),
                      cap0("cap0", 2.645E-3), 
                      indt0("indt0", 2.645E-3) 
  {
    v_in.inp(inp);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outp);
    v_out.p(n2);
    v_out.n(gnd);
     
    cap0.p(n1);
    cap0.n(n2);
 
    indt0.p(n2);
    indt0.n(gnd);
  }
  
  ~elnbndpass60(){ }
};

SCA_TDF_MODULE(comparator)
{
  sca_tdf::sca_in<double> sigin;
  sca_tdf::sca_in<double> refsig;
  sca_tdf::sca_out<double> sigout;
  sca_tdf::sca_de::sca_out<bool> sigoutde;
  double d1;
  double d2;
  double d3;
  bool deout;

  void set_attributes()
  {
    sigoutde.set_timestep(1.0, sc_core::SC_US);
    sigout.set_timestep(1.0, sc_core::SC_US);
    sigin.set_rate(1);
    sigout.set_rate(1);
    sigoutde.set_rate(1);
  }

  void processing()
  {
    d1 = sigin.read();
    d2 = refsig.read();
    d3 = (d1 > d2) ? 1.0 : 0.0;
    deout = (d3 == 1.0) ? true : false;
    sigout.write(d3);
    sigoutde.write(deout);
  }

  SCA_CTOR(comparator) : d1(0.0),
                         d2(0.0),
                         d3(0.0),
                         deout(false)
                         { }
  ~comparator(){ }
};

SCA_TDF_MODULE(onebitdac)
{
  sca_tdf::sca_in<double> sigin;
  sca_tdf::sca_out<double> sigout;
  double d0;
  double d1;

  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_US);
    sigout.set_rate(1);
    sigout.set_delay(1);
    sigin.set_rate(1);
  }

  void processing()
  {
    d0 = sigin.read();
    d1 = d0 == 1.0 ? 1.0 : -1.0;
    sigout.write(d1);
  }

  SCA_CTOR(onebitdac){ }
  ~onebitdac(){ }
};

SC_MODULE(sumwrap)
{
  private:
   sca_lsf::sca_signal sig1;
   sca_lsf::sca_signal sig2;
   sca_lsf::sca_signal sig3;
     
  public:
   sca_tdf::sca_in<double> sigin;
   sca_tdf::sca_in<double> fdbksigin;
   sca_tdf::sca_out<double> sigout;
   sca_lsf::sca_tdf::sca_source tdf2lsf0;
   sca_lsf::sca_tdf::sca_source tdf2lsf1;
   sca_lsf::sca_tdf::sca_sink lsf2tdf;
   sca_lsf::sca_sub sub_b;
  
   sumwrap(sc_core::sc_module_name):sigin("sigin"),
                                    fdbksigin("fdbksigin"),
                                    sigout("sigout"),
                                    sub_b("sub_b"),
                                    tdf2lsf0("tdf2lsf0"),
                                    tdf2lsf1("tdf2lsf1"),
                                    lsf2tdf("lsf2tdf")
  {
     tdf2lsf0.inp(sigin);
     tdf2lsf0.y(sig1);

     tdf2lsf1.inp(fdbksigin);
     tdf2lsf1.y(sig2);
    
     sub_b.x1(sig1);
     sub_b.x2(sig2);
     sub_b.y(sig3);
     
     lsf2tdf.x(sig3);
     lsf2tdf.outp(sigout);    
  }
 
  ~sumwrap(){ }
};

#endif

