#ifndef DFF2_H
#define DFF2_H

#include <systemc>

SC_MODULE(dff2) 
{
 sc_core::sc_in<bool> din;
 sc_core::sc_in<bool> clock;
 sc_core::sc_out<bool> dout;
 sc_core::sc_out<bool> dout1;
 sc_core::sc_out<bool> doutb;

 void dffoperation() 
 {
   while(true)
   {
     wait();
     dout.write(din.read());
     dout1.write(din.read());
     doutb.write(!din.read());
   }
 }
 
 SC_CTOR(dff2) 
 {
   SC_CTHREAD(dffoperation, clock.pos());
 }

 ~dff2(){}
};


SC_MODULE(dff_2)
{
 sc_core::sc_in<bool> din;
 sc_core::sc_in<bool> clock;
 sc_core::sc_out<bool> dout;
 sc_core::sc_out<bool> doutb;
 bool b0;

 void dffoperation_2()
 {
   while(true)
   {
     wait();
     b0 = din.read();
     dout.write(b0);
     doutb.write(!b0);
     std::cout<<"@ "<<sc_core::sc_time_stamp().to_seconds()<<" ";
     std::cout<<name()<<" Q "<<b0<<" Qb "<<!b0<<std::endl;
   }
 }

 SC_CTOR(dff_2):b0(false)
 {
   SC_CTHREAD(dffoperation_2, clock.pos());
 }

 ~dff_2(){}
};
#endif
