#ifndef ELNBNDPASS_H
#define ELNBNDPASS_H

#include <systemc-ams>

SC_MODULE(elnbndpass)
{
  sca_tdf::sca_in<double> inp;
  sca_tdf::sca_out<double> outp;

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_c cap0; 
  sca_eln::sca_l indt0; 

  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node_ref gnd;
  
  SC_CTOR(elnbndpass):v_in("v_in", 1.0), 
                      v_out("v_out", 1.0),
                      cap0("cap0", 1.0E-6), 
                      indt0("indt0", 1.0E-3) 
  {
    v_in.inp(inp);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outp);
    v_out.p(n2);
    v_out.n(gnd);
     
    cap0.p(n1);
    cap0.n(n2);
 
    indt0.p(n2);
    indt0.n(gnd);
  }
  
  ~elnbndpass(){ }
};

#endif

