#ifndef FECENC_H
#define FECENC_H

#include <systemc>
#include <cstdlib>

const unsigned int FEC_BLOCK_SIZE = 32;
   

SC_MODULE(fecenc)
{
  private:
   sc_dt::sc_bv<65> arr;
   sc_dt::sc_bv<32> paritybits;
   sc_dt::sc_bv<65> fecblk0;
   sc_dt::sc_bv<65> fecblk1;
   sc_dt::sc_bv<65> fecblk2;
   sc_dt::sc_bv<65> fecblk3;
   sc_dt::sc_bv<65> fecblk4;
   sc_dt::sc_bv<65> fecblk5;
   sc_dt::sc_bv<65> fecblk6;
   sc_dt::sc_bv<65> fecblk7;
   sc_dt::sc_bv<65> fecblk8;
   sc_dt::sc_bv<65> fecblk9;
   sc_dt::sc_bv<65> fecblk10;
   sc_dt::sc_bv<65> fecblk11;
   sc_dt::sc_bv<65> fecblk12;
   sc_dt::sc_bv<65> fecblk13;
   sc_dt::sc_bv<65> fecblk14;
   sc_dt::sc_bv<65> fecblk15;
   sc_dt::sc_bv<65> fecblk16;
   sc_dt::sc_bv<65> fecblk17;
   sc_dt::sc_bv<65> fecblk18;
   sc_dt::sc_bv<65> fecblk19;
   sc_dt::sc_bv<65> fecblk20;
   sc_dt::sc_bv<65> fecblk21;
   sc_dt::sc_bv<65> fecblk22;
   sc_dt::sc_bv<65> fecblk23;
   sc_dt::sc_bv<65> fecblk24;
   sc_dt::sc_bv<65> fecblk25;
   sc_dt::sc_bv<65> fecblk26;
   sc_dt::sc_bv<65> fecblk27;
   sc_dt::sc_bv<65> fecblk28;
   sc_dt::sc_bv<65> fecblk29;
   sc_dt::sc_bv<65> fecblk30;
   sc_dt::sc_bv<65> fecblk31;

  public:
   sc_dt::sc_bv<16> segment0;
   sc_dt::sc_bv<16> segment1;
   sc_dt::sc_bv<16> segment2;
   sc_dt::sc_bv<16> segment3;
   sc_dt::sc_bv<2> datatype;
   sc_dt::sc_bv<1> tcvalue;
   sc_core::sc_in< sc_dt::sc_bv<16> > tx_bit_16;
   sc_core::sc_in<bool> tx_clk;
   sc_core::sc_in<bool> txc_ctrl;
   unsigned int index1;
   unsigned int index2;

   void initialize_bv()
   {
    arr="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk0="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk1="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk2="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk3="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk4="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk5="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk6="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk7="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk8="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk9="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk10="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk11="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk12="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk13="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk14="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk15="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk16="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk17="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk18="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk19="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk20="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk21="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk22="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk23="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk24="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk25="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk26="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk27="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk28="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk29="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk30="00000000000000000000000000000000000000000000000000000000000000000";
    fecblk31="00000000000000000000000000000000000000000000000000000000000000000";
    paritybits="00000000000000000000000000000000";
    segment0="0000000000000000";
    segment1="0000000000000000";
    segment2="0000000000000000";
    segment3="0000000000000000";
  }

   void readAggregateWord()
   {
     while(true)
     {
       wait();
       if(txc_ctrl.read() == true) datatype = "10";
       else datatype = "01";

       if(tx_bit_16.read() != "0000000000000000")
       {
        switch(index1)
        {
         case 0:
          segment0 = tx_bit_16.read();
          index1 += 1;
         break;
         case 1:
          segment1 = tx_bit_16.read();
          index1 += 1;  
         break;
         case 2:
          segment2 = tx_bit_16.read();
          index1 += 1;
         break;
         case 3:
          segment3 = tx_bit_16.read();
          tcvalue[0] = datatype[1]^segment1[0];
          arr = (tcvalue, 
                  segment0, 
                  segment1, 
                  segment2, 
                  segment3);
          index1 = 0;
          switch(index2)
          {
            case 0:
             fecblk0 = arr;
             index2 += 1;
            break;
            case 1:
             fecblk1 = arr;
             index2 += 1;
            break;
            case 2:
             fecblk2 = arr;
             index2 += 1;
            break;
            case 3:
             fecblk3 = arr;
             index2 += 1;
            break;
            case 4:
             fecblk4 = arr;
             index2 += 1;
            break;
            case 5:
             fecblk5 = arr;
             index2 += 1;
            break;
            case 6:
             fecblk6 = arr;
             index2 += 1;
            break;
            case 7:
             fecblk7 = arr;
             index2 += 1;
            break;
            case 8:
             fecblk8 = arr;
             index2 += 1;
            break;
            case 9:
             fecblk9 = arr;
             index2 += 1;
            break;
            case 10:
             fecblk10 = arr;
             index2 += 1;
            break;
            case 11:
             fecblk11 = arr;
             index2 += 1;
            break;
            case 12:
             fecblk12 = arr;
             index2 += 1;
            break;
            case 13:
             fecblk13 = arr;
             index2 += 1;
            break;
            case 14:
             fecblk14 = arr;
             index2 += 1;
            break;
            case 15:
             fecblk15 = arr;
             index2 += 1;
            break;
            case 16:
             fecblk16 = arr;
             index2 += 1;
            break;
            case 17:
             fecblk17 = arr;
             index2 += 1;
            break;
            case 18:
             fecblk18 = arr;
             index2 += 1;
            break;
            case 19:
             fecblk19 = arr;
             index2 += 1;
            break;
            case 20:
             fecblk20 = arr;
             index2 += 1;
            break;
            case 21:
             fecblk21 = arr;
             index2 += 1;
            break;
            case 22:
             fecblk22 = arr;
             index2 += 1;
            break;
            case 23:
             fecblk23 = arr;
             index2 += 1;
            break;
            case 24:
             fecblk24 = arr;
             index2 += 1;
            break;
            case 25:
             fecblk25 = arr;
             index2 += 1;
            break;
            case 26:
             fecblk26 = arr;
             index2 += 1;
            break;
            case 27:
             fecblk27 = arr;
             index2 += 1;
            break;
            case 28:
             fecblk28 = arr;
             index2 += 1;
            break;
            case 29:
             fecblk29 = arr;
             index2 += 1;
            break;
            case 30:
             fecblk30 = arr;
             index2 += 1;
            break;
            case 31:
             fecblk31 = arr;
             index2 += 1;
            break;
            default:
            break;
          } 
         break;
         default:
         break;
        }
      }
    }
   }


   void genparity()
   {
     unsigned int i = 0;
     while(true)
     {
       wait();
       if(index2 == FEC_BLOCK_SIZE)
       {
         paritybits[0] = fecblk0.xor_reduce();
         paritybits[1] = fecblk1.xor_reduce();
         paritybits[2] = fecblk2.xor_reduce();
         paritybits[3] = fecblk3.xor_reduce();
         paritybits[4] = fecblk4.xor_reduce();
         paritybits[5] = fecblk5.xor_reduce();
         paritybits[6] = fecblk6.xor_reduce();
         paritybits[7] = fecblk7.xor_reduce();
         paritybits[8] = fecblk8.xor_reduce();
         paritybits[9] = fecblk9.xor_reduce();
         paritybits[10] = fecblk10.xor_reduce();
         paritybits[11] = fecblk11.xor_reduce();
         paritybits[12] = fecblk12.xor_reduce();
         paritybits[13] = fecblk13.xor_reduce();
         paritybits[14] = fecblk14.xor_reduce();
         paritybits[15] = fecblk15.xor_reduce();
         paritybits[16] = fecblk16.xor_reduce();
         paritybits[17] = fecblk17.xor_reduce();
         paritybits[18] = fecblk18.xor_reduce();
         paritybits[19] = fecblk19.xor_reduce();
         paritybits[20] = fecblk20.xor_reduce();
         paritybits[21] = fecblk21.xor_reduce();
         paritybits[22] = fecblk22.xor_reduce();
         paritybits[23] = fecblk23.xor_reduce();
         paritybits[24] = fecblk24.xor_reduce();
         paritybits[25] = fecblk25.xor_reduce();
         paritybits[26] = fecblk26.xor_reduce();
         paritybits[27] = fecblk27.xor_reduce();
         paritybits[28] = fecblk28.xor_reduce();
         paritybits[29] = fecblk29.xor_reduce();
         paritybits[30] = fecblk30.xor_reduce();
         paritybits[31] = fecblk31.xor_reduce();
         index2 = 0;
         
         std::cout<<fecblk0.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk1.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk2.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk3.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk4.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk5.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk6.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk7.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk8.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk9.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk10.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk11.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk12.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk13.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk14.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk15.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk16.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk17.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk18.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk19.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk20.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk21.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk22.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk23.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk24.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk25.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk26.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk27.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk28.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk29.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk30.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<fecblk31.to_string(sc_dt::SC_HEX)<<std::endl;
         std::cout<<paritybits.to_string(sc_dt::SC_HEX)<<std::endl;
          
       }
     }
   } 


   SC_CTOR(fecenc):index1(0),index2(0)  
   {
     SC_CTHREAD(readAggregateWord, tx_clk.pos());
     SC_CTHREAD(genparity, tx_clk.pos()); 
     initialize_bv();
   }

   ~fecenc(){ }
};

#endif
 
