#ifndef FECSRC_H
#define FECSRC_H

#include <systemc>
#include <cassert>

SC_MODULE(fecsrc)
{
  private:
   unsigned int htoi (const char *ptr)
   {
     assert(ptr != NULL);
     unsigned int value = 0;
     char ch = *ptr;

    while (ch == ' ' || 
           ch == '\t') ch = *(++ptr);

    for (;;) 
    {
      if (ch >= '0' && ch <= '9')
            value = (value << 4) + (ch - '0');
      else if (ch >= 'A' && ch <= 'F')
            value = (value << 4) + (ch - 'A' + 10);
      else if (ch >= 'a' && ch <= 'f')
            value = (value << 4) + (ch - 'a' + 10);
      else
            return value;
      ch = *(++ptr);
    }
   }
  public:
   sc_core::sc_in<bool> clk;
   sc_core::sc_out<bool> txc_ctrl;
   sc_core::sc_out< sc_dt::sc_bv<16> > tx_bit_16;
   unsigned int num;
  
  void output()
  {
    while(true)
    {
      wait();
      txc_ctrl.write(true);
     
      switch(num)
      {
        case 0:
         tx_bit_16.write("100000011101010");
         num += 1;
        break;
        case 1:
         tx_bit_16.write("0001111001110111");
         num += 1;
        break;
        case 2:
         tx_bit_16.write("1110111011010011");
         num += 1;
        break;
        case 3:
         tx_bit_16.write("0000000111101100");
         num += 1;
        break;
        case 4:
         tx_bit_16.write("1010110101011010");
         num += 1;
        break;
        case 5:
         tx_bit_16.write("0011101111111000");
         num += 1;
        break;
        case 6:
         tx_bit_16.write("0110110110011010");
         num += 1;
        break;
        case 7:
         tx_bit_16.write("1100111101011100");
         num += 1;
        break;
        case 8:
         tx_bit_16.write("1101111001010101");
         num += 1;
        break;
        case 9:
         tx_bit_16.write("1100101110001111");
         num += 1;
        break;
        case 10:
         tx_bit_16.write("1101111100001111");
         num += 1;
        break;
        case 11:
         tx_bit_16.write("0111110010100000");
         num += 1;
        break;
        case 12:
         tx_bit_16.write("1110011011001100");
         num += 1;
        break;
        case 13:
         tx_bit_16.write("1111111110001110");
         num += 1;
        break;
        case 14:
         tx_bit_16.write("1000001000010010");
         num += 1;
        break;
        case 15:
         tx_bit_16.write("1011000111000110");
         num += 1;
        break;
        case 16:
         tx_bit_16.write("1101011000111011");
         num += 1;
        break;
        case 17:
         tx_bit_16.write("1100011011000011");
         num += 1;
        break;
        case 18:
         tx_bit_16.write("0000100100000000");
         num += 1;
        break;
        case 19:
         tx_bit_16.write("0000011000111000");
         num += 1;
        break;
        case 20:
         tx_bit_16.write("0111000011100011");
         num += 1;
        break;
        case 21:
         tx_bit_16.write("1011000011001110");
         num += 1;
        break;
        case 22:
         tx_bit_16.write("0011000011100000");
         num += 1;
        break;
        case 23:
         tx_bit_16.write("0100100101111101");
         num += 1;
        break;
        case 24:
         tx_bit_16.write("1101110010001101");
         num += 1;
        break;
        case 25:
         tx_bit_16.write("1111001100011110");
         num += 1;
        break;
        case 26:
         tx_bit_16.write("1100001110101011"); /*C3AB */
         num += 1;
        break;
        case 27:
         tx_bit_16.write("0100010010010001");
         num += 1;
        break;
         case 28:
         tx_bit_16.write("0110011011111011");
         num += 1;
        break;
        case 29:
         tx_bit_16.write("1001000100111001");
         num += 1;
        break;
        case 30:
         tx_bit_16.write("1100100000011100");
         num += 1;
        break;
        case 31:
         tx_bit_16.write("1101001101111011");
         num += 1;
        break;
         case 32:
         tx_bit_16.write("1011010101110100");
         num += 1;
        break;
        case 33:
         tx_bit_16.write("111011111010100");
         num += 1;
        break;
        case 34:
         tx_bit_16.write("1111000001011110");
         num += 1;
        break;
        case 35:
         tx_bit_16.write("0011011000000010");
         num += 1;
        break;
        case 36:
         tx_bit_16.write("1000110011111101");
         num += 1;
        break;
         case 37:
         tx_bit_16.write("0100100101011101");
         num += 1;
        break;
        case 38:
         tx_bit_16.write("0001001010010100");
         num += 1;
        break;
        case 39:
         tx_bit_16.write("0111101000110001");
         num += 1;
        break;
        case 40:
         tx_bit_16.write("1110011101110111");
         num += 1;
        break;
         case 41:
         tx_bit_16.write("0111110011110000");
         num += 1;
        break;
        case 42:
         tx_bit_16.write("1100011011010000");
         num += 1;
        break;
        case 43:
         tx_bit_16.write("0110001010000000");
         num += 1;
        break;
        case 44:
         tx_bit_16.write("0100010001010010");
         num += 1;
        break;
         case 45:
         tx_bit_16.write("1001110011110100");
         num += 1;
        break;
        case 46:
         tx_bit_16.write("1011010010010000");
         num += 1;
        break;
        case 47:
         tx_bit_16.write("0000010100101000");
         num += 1;
        break;
        case 48:
         tx_bit_16.write("1000010111001110");
         num += 1;
        break;
         case 49:
         tx_bit_16.write("0001110100100111");
         num += 1;
        break;
        case 50:
         tx_bit_16.write("0111010100001010");
         num += 1;
        break;
        case 51:
         tx_bit_16.write("1101011000011011");
         num += 1;
        break;
        case 52:
         tx_bit_16.write("0100010101101101");
         num += 1;
        break;
         case 53:
         tx_bit_16.write("0101110001110001");
         num += 1;
        break;
        case 54:
         tx_bit_16.write("0111010000111111");
         num += 1;
        break;
        case 55:
         tx_bit_16.write("0101110001101001");
         num += 1;
        break;
        case 56:
         tx_bit_16.write("1100000110111111");
         num += 1;
        break;
         case 57:
         tx_bit_16.write("0110001011100101");
         num += 1;
        break;
        case 58:
         tx_bit_16.write("1101110001010100");
         num += 1;
        break;
        case 59:
         tx_bit_16.write("0110010010110101");
         num += 1;
        break;
        case 60:
         tx_bit_16.write("1101110001100000");
         num += 1;
        break;
         case 61:
         tx_bit_16.write("0001000110111110");
         num += 1;
        break;
        case 62:
         tx_bit_16.write("0111111010100001");
         num += 1;
        break;
        case 63:
         tx_bit_16.write("1110110101010100");
         num += 1;
        break;
        case 64:
         tx_bit_16.write("0001110011111001");
         num += 1;
        break;
         case 65:
         tx_bit_16.write("0010110001000101");
         num += 1;
        break;
        case 66:
         tx_bit_16.write("0000000001000010");
         num += 1;
        break;
        case 67:
         tx_bit_16.write("1010011101011111");
         num += 1;
        break;
        case 68:
         tx_bit_16.write("1100110001001011");
         num += 1;
        break;
         case 69:
         tx_bit_16.write("1001010000001110");
         num += 1;
        break;
        case 70:
         tx_bit_16.write("1010111100110001");
         num += 1;
        break;
        case 71:
         tx_bit_16.write("0100000011011011");
         num += 1;
        break;
        case 72:
         tx_bit_16.write("0111011110111011");
         num += 1;
        break;
         case 73:
         tx_bit_16.write("0110000100101010");
         num += 1;
        break;
        case 74:
         tx_bit_16.write("0111101010111111");
         num += 1;
        break;
        case 75:
         tx_bit_16.write("0100000000011111"); /*401f*/
         num += 1;
        break;
        case 76:
         tx_bit_16.write("1100001000101101");
         num += 1;
        break;
         case 77:
         tx_bit_16.write("0011010000011110");
         num += 1;
        break;
        case 78:
         tx_bit_16.write("1001000001010100");
         num += 1;
        break;
        case 79:
         tx_bit_16.write("0101110110011000");
         num += 1;
        break;
         case 80:
         tx_bit_16.write("1100111001101101");
         num += 1;
        break;
         case 81:
         tx_bit_16.write("1010111100011111");
         num += 1;
        break;
        case 82:
         tx_bit_16.write("0010010010001011");
         num += 1;
        break;
        case 83:
         tx_bit_16.write("1011110101101101");
         num += 1;
        break;
        case 84:
         tx_bit_16.write("1101110100100010");
         num += 1;
        break;
         case 85:
         tx_bit_16.write("1101000010110011");
         num += 1;
        break;
        case 86:
         tx_bit_16.write("1111100101010101");
         num += 1;
        break;
        case 87:
         tx_bit_16.write("0001111011010110");
         num += 1;
        break;
        case 88:
         tx_bit_16.write("0101011101000110");
         num += 1;
        break;
         case 89:
         tx_bit_16.write("1000011011000011");
         num += 1;
        break;
        case 90:
         tx_bit_16.write("1111100111101001");
         num += 1;
        break;
        case 91:
         tx_bit_16.write("0011100010011000");
         num += 1;
        break;
        case 92:
         tx_bit_16.write("0010111001010010");
         num += 1;
        break;
         case 93:
         tx_bit_16.write("0110001010001111");
         num += 1;
        break;
        case 94:
         tx_bit_16.write("0100101000010010");
         num += 1;
        break;
        case 95:
         tx_bit_16.write("1000001011001110");
         num += 1;
        break;
        case 96:
         tx_bit_16.write("1111001000001100");
         num += 1;
        break;
        case 97:
         tx_bit_16.write("1000011011010111");
         num += 1;
        break;
         case 98:
         tx_bit_16.write("0001100101000100");
         num += 1;
        break;
        case 99:
         tx_bit_16.write("1010101010110001");
         num += 1;
        break;
        case 100:
         tx_bit_16.write("0101010100010011");
         num += 1;
        break;
        case 101:
         tx_bit_16.write("0011110010010011");
         num += 1;
        break;
         case 102:
         tx_bit_16.write("0011001110000000");
         num += 1;
        break;
        case 103:
         tx_bit_16.write("1000101000101100");
         num += 1;
        break;
        case 104:
         tx_bit_16.write("0001101010101000");
         num += 1;
        break;
        case 105:
         tx_bit_16.write("0010010111011000");
         num += 1;
        break;
         case 106:
         tx_bit_16.write("1011100000010111");
         num += 1;
        break;
        case 107:
         tx_bit_16.write("1101101101001101");
         num += 1;
        break;
        case 108:
         tx_bit_16.write("0110001101111001");
         num += 1;
        break;
         case 109:
         tx_bit_16.write("0101100110011000");
         num += 1;
        break;
         case 110:
         tx_bit_16.write("1001111100110000"); 
         num += 1;
        break;
        case 111:
         tx_bit_16.write("0010000111101011");/*21EB*/
         num += 1;
        break;
        case 112:
         tx_bit_16.write("1001011101101000");
         num += 1;
        break;
         case 113:
         tx_bit_16.write("0000011001100100");
         num += 1;
        break;
         case 114:
         tx_bit_16.write("0001101100100110");
         num += 1;
        break;
        case 115:
         tx_bit_16.write("1010101011101001"); /*AAE9*/
         num += 1;
        break;
        case 116:
         tx_bit_16.write("110101000110111");
         num += 1;
        break;
          case 117:
         tx_bit_16.write("1101010001010011");
         num += 1;
        break;
         case 118:
         tx_bit_16.write("0001101101111110");
         num += 1;
        break;
        case 119:
         tx_bit_16.write("1101010111110010");
         num += 1;
        break;
        case 120:
         tx_bit_16.write("0101001111000011");
         num += 1;
        break;
          case 121:
         tx_bit_16.write("1110100101101101");
         num += 1;
        break;
         case 122:
         tx_bit_16.write("0011101100010010");
         num += 1;
        break;
        case 123:
         tx_bit_16.write("1111101101000110");
         num += 1;
        break;
        case 124:
         tx_bit_16.write("101001010001100");
         num += 1;
        break;
        case 125:
         tx_bit_16.write("111111010111000");
         num += 1;
        break;
        case 126:
         tx_bit_16.write("100100000011011");
         num += 1;
        break;
        case 127:
         tx_bit_16.write("1100100101101001");
         num += 1;
        break;
        default:
        break;
      }
     }
  }

  SC_CTOR(fecsrc):num(0)
  {
    SC_CTHREAD(output, clk.pos());
  }

  ~fecsrc() { }
};

#endif

