#ifndef FILTFORDBTWELN_H
#define FILTFORDBTWELN_H

#include <systemc-ams>

SC_MODULE(filtfordbtweln)
{
  sca_tdf::sca_in<double> inp;
  sca_tdf::sca_out<double> outp;

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  
  sca_eln::sca_nullor nullr0;
  sca_eln::sca_nullor nullr1;
  sca_eln::sca_nullor nullr2;
  
  sca_eln::sca_c c0;  
  sca_eln::sca_c c1;
  sca_eln::sca_c c2;
  sca_eln::sca_c c3;
  sca_eln::sca_c c4;
 
  sca_eln::sca_r r0;
  sca_eln::sca_r r1;
  sca_eln::sca_r r2;
  sca_eln::sca_r r3;
  sca_eln::sca_r r4;

  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node n3;
  sca_eln::sca_node n4;
  sca_eln::sca_node n5;
  sca_eln::sca_node n6;
  sca_eln::sca_node n7;
  sca_eln::sca_node n8;
  sca_eln::sca_node n9;
  sca_eln::sca_node_ref gnd;

  void set_attributes()
  {
    inp.set_rate(1);
    outp.set_timestep(1.0, sc_core::SC_US);
    outp.set_rate(1);
  }

  SC_CTOR(filtfordbtweln): v_in("v_in", 1.0),
                           v_out("v_out", 1.0),
                           nullr0("nullr0"),
                           nullr1("nullr1"),
                           nullr2("nullr2"),
                           c0("c0", 1.0E-6),
                           c1("c1", 1.0E-6),
                           c2("c2", 2.5E-6),
                           c3("c3", 1.0E-6),
                           c4("c4", 15.0E-6),
                           r0("r0", 2650.0),
                           r1("r1", 3697.0),
                           r2("r2", 763.0),
                           r3("r3", 1210.0),
                           r4("r4", 390.0)
  {
    v_in.inp(inp);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outp);
    v_out.p(n9);  
    v_out.n(gnd); 
   
    nullr0.nip(n2);
    nullr0.nin(n3);
    nullr0.nop(n3);
    nullr0.non(gnd);
    
    r0.p(n1);
    r0.n(n2);
    c0.p(n2);
    c0.n(gnd);

    r1.p(n3);
    r1.n(n4);
    r2.p(n4);
    r2.n(n5);

    nullr1.nip(n5);
    nullr1.nin(n6);
    nullr1.nop(n6);
    nullr1.non(gnd);
    
    c1.p(n4);
    c1.n(n6);
   
    c2.p(n5);
    c2.n(gnd);

    r3.p(n6);
    r3.n(n7);
    
    r4.p(n7);
    r4.n(n8);

    nullr2.nip(n8);
    nullr2.nin(n9);
    nullr2.nop(n9);
    nullr2.non(gnd);

    c3.p(n7);
    c3.n(n9);
    c4.p(n8);
    c4.n(gnd);
  }

  ~filtfordbtweln(){ }

};

#endif

