#ifndef FSM_H
#define FSM_H

#include <systemc>

const char *str0 = "IDLE";
const char *str1 = "MOVE";

SC_MODULE(fsm_input_src)
{
  public:
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<bool> fsm_input_out;
  bool out_value;
  bool out_value_stored;
  unsigned int value;

  void fsm_input_src_proc0()
  {
    while(1)
    {
      wait();
      value = (unsigned int)(10.0*drand48());
      if((value % 2 == 0) && (value % 7 == 0) )
      { 
        out_value_stored = out_value;
        out_value = true;
      }
      else
      {
        out_value = false;
      }
      fsm_input_out.write(out_value_stored);
    }
  }
       
  SC_CTOR(fsm_input_src):out_value(false), 
                         out_value_stored(false),
                         value(0)
  {
    SC_CTHREAD(fsm_input_src_proc0, clk.pos());
  }
  
  ~fsm_input_src() { }
};
 

SC_MODULE(fsm)
{
  private:
   bool state_var;
   enum states{IDLE=1, MOVE};
   unsigned int curr_state;
  public:
   sc_core::sc_in<bool> fsm_in;
   sc_core::sc_out<unsigned int> curr_state_out;
   double curr_time;

   void fsm_proc0()
   {
     while(1)
     {
       wait();
       state_var = fsm_in.read();
       curr_state = state_var == true ? MOVE : IDLE;
       curr_state_out.write(curr_state);
       curr_time = sc_core::sc_time_stamp().to_seconds();
       if(curr_state == MOVE) 
        std::cout<<"@ "<<std::scientific<<curr_time<<" seconds "<<str1<<std::endl;
       else 
        std::cout<<"@ "<<std::scientific<<curr_time<<" seconds "<<str0<<std::endl;
     }
   }

   SC_CTOR(fsm): state_var(false), curr_state(IDLE)
   {
     SC_THREAD(fsm_proc0);
     sensitive << fsm_in;
   }

   ~fsm(){ }
};

#endif

