#ifndef N2_CL_U1_H
#define N2_CL_U1_H

#include <systemc.h>

SC_MODULE(cl_u1_aoi12_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi12_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
    }
  }

  SC_CTOR(cl_u1_aoi12_12x)
  { SC_METHOD(u1_aoi12_12x_proc0); }
  ~cl_u1_aoi12_12x(){ }
};


SC_MODULE(cl_u1_aoi12_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
 
  void u1_aoi12_16x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
    }
  }

  SC_CTOR(cl_u1_aoi12_16x){ SC_METHOD(u1_aoi12_16x_proc0); }
  ~cl_u1_aoi12_16x(){ }
};


SC_MODULE(cl_u1_aoi12_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi12_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi12_1x){ SC_METHOD(u1_aoi12_1x_proc0); }
  ~cl_u1_aoi12_1x(){ }
};


SC_MODULE(cl_u1_aoi12_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi12_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi12_2x) { SC_METHOD(u1_aoi12_2x_proc0); }
  ~cl_u1_aoi12_2x(){ }
};


SC_MODULE(cl_u1_aoi12_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;  
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi12_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi12_4x){ SC_METHOD(u1_aoi12_4x_proc0); }
  ~cl_u1_aoi12_4x() { }
};

SC_MODULE(cl_u1_aoi12_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;  
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi12_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !(b2 | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() ) | ( in00.read() & in01.read() )))
;
      */
    }
  }

  SC_CTOR(cl_u1_aoi12_8x){ SC_METHOD(u1_aoi12_8x_proc0); }
  ~cl_u1_aoi12_8x() { }
};


SC_MODULE(cl_u1_aoi21_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_12x){ SC_METHOD(u1_aoi21_12x_proc0); }
  ~cl_u1_aoi21_12x(){ }
};

SC_MODULE(cl_u1_aoi21_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_16x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_16x){ SC_METHOD(u1_aoi21_16x_proc0); }
  ~cl_u1_aoi21_16x(){ }
};


SC_MODULE(cl_u1_aoi21_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_1x){ SC_METHOD(u1_aoi21_1x_proc0); }
  ~cl_u1_aoi21_1x(){ }
};

SC_MODULE(cl_u1_aoi21_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_2x){ SC_METHOD(u1_aoi21_2x_proc0); }
  ~cl_u1_aoi21_2x(){ }
};

SC_MODULE(cl_u1_aoi21_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_4x){ SC_METHOD(u1_aoi21_4x_proc0); }
  ~cl_u1_aoi21_4x( ){ }
};


SC_MODULE(cl_u1_aoi21_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB; 
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_aoi21_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 & b2) | b0);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Out : "<<b3<<endl;
      out.write(b3);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi21_8x){ SC_METHOD(u1_aoi21_8x_proc0); }
  ~cl_u1_aoi21_8x(){ }
};


SC_MODULE(cl_u1_aoi22_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;  
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
 
  void u1_aoi22_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 & b3) | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
      out.write(b4);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() ))); 
      */
    }
  }

  SC_CTOR(cl_u1_aoi22_12x) { SC_METHOD(u1_aoi22_12x_proc0); }
  ~cl_u1_aoi22_12x() { }
};


SC_MODULE(cl_u1_aoi22_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_aoi22_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 & b3) | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
      out.write(b4);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi22_1x){ SC_METHOD(u1_aoi22_1x_proc0); }
  ~cl_u1_aoi22_1x(){ }
};


SC_MODULE(cl_u1_aoi22_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_aoi22_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = ~((b2 & b3) | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
      out.write(b4);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi22_2x){ SC_METHOD(u1_aoi22_2x_proc0); }
  ~cl_u1_aoi22_2x(){ }
};


SC_MODULE(cl_u1_aoi22_4x )
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_aoi22_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = ~((b2 & b3) | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
      out.write(b4);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi22_4x ){ SC_METHOD(u1_aoi22_4x_proc0); }
  ~cl_u1_aoi22_4x( ){ }
};


SC_MODULE(cl_u1_aoi22_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_aoi22_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = ~((b2 & b3) | (b0 & b1));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
      out.write(b4);
      /*
      out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi22_8x){ SC_METHOD(u1_aoi22_8x_proc0); }
  ~cl_u1_aoi22_8x(){ }
};


SC_MODULE(cl_u1_aoi33_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;

  void u1_aoi33_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = in02.read();
      b5 = in12.read();
      b6 = !((b2 & b3 & b5) | (b0 & b1 & b4));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" "<<b4<<" "<<b5<<" out : "<<b6<<endl;
      out.write(b6);
      /*
      out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi33_1x){ SC_METHOD(u1_aoi33_1x_proc0); }
  ~cl_u1_aoi33_1x(){ }
};


SC_MODULE(cl_u1_aoi33_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;

  void u1_aoi33_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = in02.read();
      b5 = in12.read();
      b6 = !((b2 & b3 & b5) | (b0 & b1 & b4));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" "<<b4<<" "<<b5<<" out : "<<b6<<endl;
      out.write(b6);
      /*
      out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi33_2x){ SC_METHOD(u1_aoi33_2x_proc0); }
  ~cl_u1_aoi33_2x(){ }
};


SC_MODULE(cl_u1_aoi33_4x)
{
  sc_core::sc_out<bool>  out;
  sc_core::sc_in<bool>   in10;
  sc_core::sc_in<bool>   in11;
  sc_core::sc_in<bool>   in12;
  sc_core::sc_in<bool>   in00;
  sc_core::sc_in<bool>   in01;
  sc_core::sc_in<bool>   in02;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;

  void u1_aoi33_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = in02.read();
      b5 = in12.read();
      b6 = !((b2 & b3 & b5) | (b0 & b1 & b4));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" "<<b4<<" "<<b5<<" out : "<<b6<<endl;
      out.write(b6);
      /*
      out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi33_4x){ SC_METHOD(u1_aoi33_4x_proc0); }
  ~cl_u1_aoi33_4x(){ }
};

SC_MODULE(cl_u1_aoi33_8x)
{
  sc_core::sc_out<bool>  out;
  sc_core::sc_in<bool>   in10;
  sc_core::sc_in<bool>   in11;
  sc_core::sc_in<bool>   in12;
  sc_core::sc_in<bool>   in00;
  sc_core::sc_in<bool>   in01;
  sc_core::sc_in<bool>   in02;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;

  void u1_aoi33_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = in02.read();
      b5 = in12.read();
      b6 = !((b2 & b3 & b5) | (b0 & b1 & b4));
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" "<<b4<<" "<<b5<<" out : "<<b6<<endl;
      out.write(b6);
      /*
      out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_aoi33_8x){ SC_METHOD(u1_aoi33_8x_proc0); }
  ~cl_u1_aoi33_8x(){ }
};

SC_MODULE(cl_u1_rep_lvt_32x)
{
 sc_core::sc_in<bool> in;
 sc_core::sc_out<bool> out;
 bool LIB;
   
 void u1_rep_lvt_32x_proc0()
 {
   if(LIB == true)
   {
     out.write(in.read());
   }
 }

 SC_CTOR(cl_u1_rep_lvt_32x){ SC_METHOD(u1_rep_lvt_32x_proc0); }
 ~cl_u1_rep_lvt_32x(){ }
};


SC_MODULE(cl_u1_rep_lvt_48x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_lvt_48x_proc0()
  {
    if(LIB == true)
    {
        out.write(in.read());
    }
  }

 SC_CTOR(cl_u1_rep_lvt_48x){ SC_METHOD(u1_rep_lvt_48x_proc0); }
 ~cl_u1_rep_lvt_48x() { }
};


SC_MODULE(cl_u1_rep_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_32x){ SC_METHOD(u1_rep_32x_proc0); }
  ~cl_u1_rep_32x(){ }
};
 

SC_MODULE(cl_u1_rep_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_40x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_40x){ SC_METHOD(u1_rep_40x_proc0); }
  ~cl_u1_rep_40x(){ }
};

SC_MODULE(cl_u1_rep_24x)
{
  sc_core::sc_in<bool> 	in;
  sc_core::sc_out<bool> 	out;
  bool LIB;

  void u1_rep_24x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_24x){ SC_METHOD(u1_rep_24x_proc0); }
  ~cl_u1_rep_24x(){ }
};


SC_MODULE(cl_u1_rep_16x)
{
 sc_core::sc_in<bool> in;
 sc_core::sc_out<bool> out;
 bool LIB;

 void u1_rep_16x_proc0()
 {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_16x){ SC_METHOD(u1_rep_16x_proc0); }
  ~cl_u1_rep_16x(){ }
};

SC_MODULE(cl_u1_rep_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_rep_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_8x){ SC_METHOD(u1_rep_8x_proc0); }
  ~cl_u1_rep_8x(){ }
};

SC_MODULE(cl_u1_rep_48x)
{ 
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_rep_48x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_48x){ SC_METHOD(u1_rep_48x_proc0); }
  ~cl_u1_rep_48x(){ }
};
  
SC_MODULE(cl_u1_rep_dcp2x_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp2x_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp2x_32x){ SC_METHOD(u1_rep_dcp2x_32x_proc0); }
  ~cl_u1_rep_dcp2x_32x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp2x_16x)
{
  sc_core::sc_in<bool> 	in;
  sc_core::sc_out<bool> 	out;
  bool LIB;

  void u1_rep_dcp2x_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp2x_16x){ SC_METHOD(u1_rep_dcp2x_16x_proc0); }
  ~cl_u1_rep_dcp2x_16x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp2x_24x)
{
 sc_core::sc_in<bool> 	in;
 sc_core::sc_out<bool> 	out;
 bool LIB;

  void u1_rep_dcp2x_24x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp2x_24x){ SC_METHOD(u1_rep_dcp2x_24x_proc0); }
  ~cl_u1_rep_dcp2x_24x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp2x_40x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp2x_40x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp2x_40x){ SC_METHOD(u1_rep_dcp2x_40x_proc0); }
  ~cl_u1_rep_dcp2x_40x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp2x_48x) 
{
  sc_core::sc_in<bool> 	in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp2x_48x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp2x_48x){ SC_METHOD(u1_rep_dcp2x_48x_proc0); }
  ~cl_u1_rep_dcp2x_48x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp_32x)
{
  sc_core::sc_in<bool> 	in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp_32x){ SC_METHOD(u1_rep_dcp_32x_proc0); }
  ~cl_u1_rep_dcp_32x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp_16x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp_16x){ SC_METHOD(u1_rep_dcp_16x_proc0); }
  ~cl_u1_rep_dcp_16x(){ }
}; 

SC_MODULE(cl_u1_rep_dcp_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp_24x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp_24x){ SC_METHOD(u1_rep_dcp_24x_proc0); }
  ~cl_u1_rep_dcp_24x(){ }
};

SC_MODULE(cl_u1_rep_dcp_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp_40x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp_40x){ SC_METHOD(u1_rep_dcp_40x_proc0); }
  ~cl_u1_rep_dcp_40x(){ }
};

SC_MODULE(cl_u1_rep_dcp_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp_48x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp_48x){ SC_METHOD(u1_rep_dcp_48x_proc0); }
  ~cl_u1_rep_dcp_48x(){ }
};

SC_MODULE(cl_u1_rep_dcp50k_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp50k_48x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp50k_48x){ SC_METHOD(u1_rep_dcp50k_48x_proc0); }
  ~cl_u1_rep_dcp50k_48x(){ }
};

SC_MODULE(cl_u1_rep_dcp50k_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp50k_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp50k_32x){ SC_METHOD(u1_rep_dcp50k_32x_proc0); }
  ~cl_u1_rep_dcp50k_32x(){ }
};

SC_MODULE(cl_u1_rep_dcp50k_40x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_rep_dcp50k_40x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_rep_dcp50k_40x){ SC_METHOD(u1_rep_dcp50k_40x_proc0); }
  ~cl_u1_rep_dcp50k_40x(){ }
};

SC_MODULE(cl_u1_buf_12x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_12x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_12x){ SC_METHOD(u1_buf_12x_proc0); }
  ~cl_u1_buf_12x(){ }
};

SC_MODULE(cl_u1_buf_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_16x){ SC_METHOD(u1_buf_16x_proc0); }
  ~cl_u1_buf_16x(){ }
};

SC_MODULE(cl_u1_buf_1x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_1x){ SC_METHOD(u1_buf_1x_proc0); }
  ~cl_u1_buf_1x(){ }
};

SC_MODULE(cl_u1_buf_20x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_20x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_20x){ SC_METHOD(u1_buf_20x_proc0); }
  ~cl_u1_buf_20x(){ }
};

SC_MODULE(cl_u1_buf_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_24x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_24x){ SC_METHOD(u1_buf_24x_proc0); }
  ~cl_u1_buf_24x(){ }
};

SC_MODULE(cl_u1_buf_28x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_28x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_28x){ SC_METHOD(u1_buf_28x_proc0); }
  ~cl_u1_buf_28x(){ }
};

SC_MODULE(cl_u1_buf_2x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_2x){ SC_METHOD(u1_buf_2x_proc0); }
  ~cl_u1_buf_2x(){ }
};

SC_MODULE(cl_u1_buf_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_32x){ SC_METHOD(u1_buf_32x_proc0); }
  ~cl_u1_buf_32x(){ }
};


SC_MODULE(cl_u1_buf_36x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_36x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_36x){ SC_METHOD(u1_buf_36x_proc0); }
  ~cl_u1_buf_36x(){ }
};

SC_MODULE(cl_u1_buf_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_40x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_40x){ SC_METHOD(u1_buf_40x_proc0); }
  ~cl_u1_buf_40x(){ }
};

SC_MODULE(cl_u1_buf_44x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_44x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_44x){ SC_METHOD(u1_buf_44x_proc0); }
  ~cl_u1_buf_44x(){ }
};


SC_MODULE(cl_u1_buf_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_48x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_48x){ SC_METHOD(u1_buf_48x_proc0); }
  ~cl_u1_buf_48x(){ }
};

SC_MODULE(cl_u1_buf_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_4x){ SC_METHOD(u1_buf_4x_proc0); }
  ~cl_u1_buf_4x(){ }
};

SC_MODULE(cl_u1_buf_56x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_buf_56x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_56x){ SC_METHOD(u1_buf_56x_proc0); }
  ~cl_u1_buf_56x(){ }
};

SC_MODULE(cl_u1_buf_64x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_buf_64x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_64x){ SC_METHOD(u1_buf_64x_proc0); }
  ~cl_u1_buf_64x(){ }
};

SC_MODULE(cl_u1_buf_6x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
   bool LIB;

  void u1_buf_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_6x){ SC_METHOD(u1_buf_6x_proc0); }
  ~cl_u1_buf_6x(){ }
};

SC_MODULE(cl_u1_buf_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_buf_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_buf_8x){ SC_METHOD(u1_buf_8x_proc0); }
  ~cl_u1_buf_8x(){ }
};

SC_MODULE(cl_u1_bufmin_15ps_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_15ps_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_15ps_32x){ SC_METHOD(u1_bufmin_15ps_32x_proc0); }
  ~cl_u1_bufmin_15ps_32x(){ }
};

SC_MODULE(cl_u1_bufmin_1x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_1x){ SC_METHOD(u1_bufmin_1x_proc0); }
  ~cl_u1_bufmin_1x(){ }
};

SC_MODULE(cl_u1_bufmin_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_4x){ SC_METHOD(u1_bufmin_4x_proc0); }
  ~cl_u1_bufmin_4x(){ }
};

SC_MODULE(cl_u1_bufmin_8x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_8x){ SC_METHOD(u1_bufmin_8x_proc0); }
  ~cl_u1_bufmin_8x(){ }
};

SC_MODULE(cl_u1_bufmin_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_16x){ SC_METHOD(u1_bufmin_16x_proc0); }
  ~cl_u1_bufmin_16x(){ }
};

SC_MODULE(cl_u1_bufmin_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_bufmin_32x_proc0()
  {
    if(LIB == true)
    {
      out.write(in.read());
    }
  }
  
  SC_CTOR(cl_u1_bufmin_32x){ SC_METHOD(u1_bufmin_32x_proc0); }
  ~cl_u1_bufmin_32x(){ }
};

SC_MODULE(cl_u1_csa32_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool>	sum;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_csa32_16x_proc0()
  {
    while(1)
    {
      wait();
      if(LIB == true)
      {
       b0 = in0.read(); 
       b1 = in1.read();
       b2 = in2.read();
       b3 = ((b0 & b1) | (b0 & b2) | (b1 & b2));
       b4 = (b0 ^ b1 ^ b2);
       std::cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<" Sum "<<b4<<" Carry "<<b3<<std::endl;
      carry.write(b3);
      sum.write(b4);
      /*
      carry.write((in0.read() & in1.read()) | (in0.read() & in2.read()) | (in1.read() & in2.read()));
      sum.write((in0.read() ^ in1.read() ^ in2.read()));
      */
     }
    }
  }

  SC_CTOR(cl_u1_csa32_16x)
  { 
     SC_THREAD(u1_csa32_16x_proc0);
     sensitive << in0 << in1 << in2; 
  }
  ~cl_u1_csa32_16x(){ }
};


SC_MODULE(cl_u1_csa32_4x) 
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool> sum;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_csa32_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = ((b0 & b1) | (b0 & b2) | (b1 & b2));
      b4 = (b0 ^ b1 ^ b2);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Sum "<<b4<<" "<<" Carry "<<b3<<endl;
      carry.write(b3);
      sum.write(b4);
      /*
      carry.write((in0.read() & in1.read()) | (in0.read() & in2.read()) | (in1.read() & in2.read()));
      sum.write((in0.read() ^ in1.read() ^ in2.read()));
      */
    }
  }

  SC_CTOR(cl_u1_csa32_4x){ SC_METHOD(u1_csa32_4x_proc0); }
  ~cl_u1_csa32_4x(){ }
};

SC_MODULE(cl_u1_csa32_8x) 
{
  sc_core::sc_in<bool> 	in0;
  sc_core::sc_in<bool> 	in1;
  sc_core::sc_in<bool> 	in2;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool>	sum;

  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_csa32_8x_proc0()
  {
    while(1)
    {
      wait();
      if(LIB == true)
      {
       b0 = in0.read();
       b1 = in1.read();
       b2 = in2.read();
       b3 = ((b0 & b1) | (b0 & b2) | (b1 & b2));
       b4 = (b0 ^ b1 ^ b2);
       cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" Sum "<<b4<<" Carry : "<<b3<<endl;
       carry.write(b3);
       sum.write(b4);
      /*
      carry.write((in0.read() & in1.read()) | (in0.read() & in2.read()) | (in1.read() & in2.read()));
      sum.write((in0.read() ^ in1.read() ^ in2.read()));
      */
     }
    }
  }

  SC_CTOR(cl_u1_csa32_8x)
  { 
    SC_THREAD(u1_csa32_8x_proc0);
    sensitive << in0 << in1 << in2; 
  }
  ~cl_u1_csa32_8x(){ }
};

SC_MODULE(cl_u1_csa42_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> cin;
  sc_core::sc_out<bool> carrout;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool>	sum;
  bool LIB;
  bool b0;
  bool b1;

  bool b3;
  bool b4;
  bool b5;
  bool b6;
  bool b7;
  bool b8;
  bool b9;
  bool b10;

  void u1_csa42_16x_proc0()
  {
     b3 = in0.read();
     b4 = in1.read();
     b5 = in2.read();
     b6 = in3.read();
     b7 = cin.read();
     b8 = ((b4 & b5) | (b3 & b5) | (b3 & b4));
     b9 = ((!b3 & !b4 & !b5 & !b6 & b7) | 
           (!b3 & !b4 & !b5 & b6 & !b7) | 
           (!b3 & !b4 & b5 & !b6 & !b7) | 
           (!b3 & !b4 & b5 & b6 & b7) | 
           (!b3 & b4 & !b5 & !b6 & !b7) | 
           (!b3 & b4 & !b5 & b6 & b7) | 
           (!b3 & b3 & b5 & !b6 & b7) | 
           (!b3 & b4 & b5 & b6 & !b7) | 
           (b3 & !b4 & !b5 & !b6 & !b7) | 
           (b3 & !b4 & !b5 & b6 & b7) | 
           (b3 & !b4 & b5 & !b6 & b7) | 
           (b3 & !b4 & b5 & b6 & !b7) | 
           (b3 & b4 & !b5 & !b6 & b7) | 
           (b3 & b4 & !b5 & b6 & !b7) | 
           (b3 & b4 & b5 & !b6 & !b7) | 
           (b3 & b4 & b5 & b6 & b7));
    
     b10 =  ((!b3 & !b4 & !b5 & !b6 & b0) | 
             (!b3 & !b4 & !b5 & b6 & b7) | 
             (!b3 & !b4 & b5 & !b6 & b7) | 
             (!b3 & !b4 & b5 & b6 & b1) | 
             (!b3 & b4 & !b5 & !b6 & b7) | 
             (!b3 & b3 & !b5 & b6 & b1) | 
             (!b3 & b4 & b5 & !b6 & b0) | 
             (!b3 & b4 & b5 & b6 & b7) | 
             (b3 & !b4 & !b5 & !b6 & b7) | 
             (b3 & !b4 & !b5 & b6 & b1) | 
             (b3 & !b4 & b5 & !b6 & b0) | 
             (b3 & !b4 & b5 & b6 & b7) | 
             (b3 & b4 & !b5 & !b6 & b0) | 
             (b3 & b4 & !b5 & b6 & b7) | 
             (b3 & b4 & b5 & !b6 & b7) | 
             (b3 & b4 & b5 & b6 & b1));
     carrout.write(b8);
     sum.write(b9);
     carry.write(b10);
     cout<<" b0 = "<<b0<<" b1 = "<<b1<<" In : "<<b3<<" "<<b4<<" "<<b5<<" "<<b6<<" "<<b7<<" Out : "<<b8<<" "<<b9<<" "<<b10<<endl;
  }
/*
     cout.write((in1.read() & in2.read()) | (in0.read() & in2.read()) | (in0.read() & in1.read()));

     sum.write((~in0.read() & ~in1.read() & ~in2.read() & ~(in3.read()) &  cin.read()) |
 (~in0.read() & ~in1.read() & ~in2.read() &  in3.read() & ~(cin.read())) |
 (~in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & ~(cin.read())) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() &  in3.read() &  cin.read()));

  carry.write((~(in0.read()) & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & b0) |
 (~(in0.read()) & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() & b1) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() & b1) |
 (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) & b0) |
 (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() &  cin.read()) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 ( in0.read() & ~(in1.read()) & ~(in2.read() &  in3.read() & b1) |
 ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & b0) |
 ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |
 ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) & b0) |
 ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
 ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |//
 ( in0.read() &  in1.read() &  in2.read() &  in3.read() & b1)));
 
 } */

 SC_CTOR(cl_u1_csa42_16x):b0(false), b1(true)
 { SC_METHOD(u1_csa42_16x_proc0); }

 ~cl_u1_csa42_16x() { }
};

SC_MODULE(cl_u1_csa42_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> cin;
  sc_core::sc_out<bool> carrout;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool>	sum;
  bool LIB;
  bool b0;
  bool b1;

  bool b3;
  bool b4;
  bool b5;
  bool b6;
  bool b7;
  bool b8;
  bool b9;
  bool b10;

  void u1_csa42_4x_proc0()
  {
    b3 = in0.read();
    b4 = in1.read();
    b5 = in2.read();
    b6 = in3.read();
    b7 = cin.read();
    b8 = ((b4 & b5) | (b3 & b5) | (b3 & b4));
    
    b9 = ((!b3 & !b4 & !b5 & !b6 & b7) |
           (!b3 & !b4 & !b5 & b6 & !b7) |
           (!b3 & !b4 & b5 & !b6 & !b7) |
           (!b3 & !b4 & b5 & b6 & b7) |
           (!b3 & b4 & !b5 & !b6 & !b7) |
           (!b3 & b4 & !b5 & b6 & b7) |
           (!b3 & b3 & b5 & !b6 & b7) |
           (!b3 & b4 & b5 & b6 & !b7) |
           (b3 & !b4 & !b5 & !b6 & !b7) |
           (b3 & !b4 & !b5 & b6 & b7) |
           (b3 & !b4 & b5 & !b6 & b7) |
           (b3 & !b4 & b5 & b6 & !b7) |
           (b3 & b4 & !b5 & !b6 & b7) |
           (b3 & b4 & !b5 & b6 & !b7) |
           (b3 & b4 & b5 & !b6 & !b7) |
           (b3 & b4 & b5 & b6 & b7));

      b10 =  ((!b3 & !b4 & !b5 & !b6 & b0) |
             (!b3 & !b4 & !b5 & b6 & b7) |
             (!b3 & !b4 & b5 & !b6 & b7) |
             (!b3 & !b4 & b5 & b6 & b1) |
             (!b3 & b4 & !b5 & !b6 & b7) |
             (!b3 & b3 & !b5 & b6 & b1) |
             (!b3 & b4 & b5 & !b6 & b0) |
             (!b3 & b4 & b5 & b6 & b7) |
             (b3 & !b4 & !b5 & !b6 & b7) |
             (b3 & !b4 & !b5 & b6 & b1) |
             (b3 & !b4 & b5 & !b6 & b0) |
             (b3 & !b4 & b5 & b6 & b7) |
             (b3 & b4 & !b5 & !b6 & b0) |
             (b3 & b4 & !b5 & b6 & b7) |
             (b3 & b4 & b5 & !b6 & b7) |
             (b3 & b4 & b5 & b6 & b1));
     
     carrout.write(b8);
     sum.write(b9);
     carry.write(b10);
     cout<<" b0 = "<<b0<<" b1 = "<<b1<<" In : "<<b3<<" "<<b4<<" "<<b5<<" "<<b6<<" "<<b7<<" Out : "<<b8<<" "<<b9<<" "<<b10<<endl;
   }
    /*
     cout.write((in1.read() & in2.read()) | (in0.read() & in2.read()) | (in0.read() & in1.read()));

     sum.write((~in0.read() & ~in1.read() & ~in2.read() & ~(in3.read()) &  cin.read()) |
 (~in0.read() & ~in1.read() & ~in2.read() &  in3.read() & ~(cin.read())) |
 (~in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & ~(cin.read())) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() &  in3.read() &  cin.read()));

  carry.write((~(in0.read()) & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & b0) |
 (~(in0.read()) & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() & b1) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() & b1) |
 (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) & b0) |
 (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() &  cin.read()) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 ( in0.read() & ~(in1.read()) & ~(in2.read() &  in3.read() & b1) |
 ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & b0) |
 ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |
 ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) & b0) |
 ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
 ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |
 ( in0.read() &  in1.read() &  in2.read() &  in3.read() & b1)));
 
 } */

 SC_CTOR(cl_u1_csa42_4x):b0(false), b1(true){ SC_METHOD(u1_csa42_4x_proc0); }
 ~cl_u1_csa42_4x() { }
};

SC_MODULE(cl_u1_csa42_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> cin;
  sc_core::sc_out<bool> cout;
  sc_core::sc_out<bool>	carry;
  sc_core::sc_out<bool>	sum;
  bool LIB;
  bool b0;
  bool b1;

  bool b3;
  bool b4;
  bool b5;
  bool b6;
  bool b7;
  bool b8;
  bool b9;
  bool b10;
  bool b11;
 
  void u1_csa42_8x_proc0()
  {
    b3 = in0.read();
    b4 = in1.read();
    b5 = in2.read();
    b6 = in3.read();
    b7 = cin.read();
    b9 = ((b4 & b5) | (b3 & b5) | (b3 & b4));
    b10 = ((!b3 & !b4 & !b5 & !b6 & b7) |
           (!b3 & !b4 & !b5 & b6 & !b7) |
           (!b3 & !b4 & b5 & !b6 & !b7) |
           (!b3 & !b4 & b5 & b6 & b7) |
           (!b3 & b4 & !b5 & !b6 & !b7) |
           (!b3 & b4 & !b5 & b6 & b7) |
           (!b3 & b3 & b5 & !b6 & b7) |
           (!b3 & b4 & b5 & b6 & !b7) |
           (b3 & !b4 & !b5 & !b6 & !b7) |
           (b3 & !b4 & !b5 & b6 & b7) |
           (b3 & !b4 & b5 & !b6 & b7) |
           (b3 & !b4 & b5 & b6 & !b7) |
           (b3 & b4 & !b5 & !b6 & b7) |
           (b3 & b4 & !b5 & b6 & !b7) |
           (b3 & b4 & b5 & !b6 & !b7) |
           (b3 & b4 & b5 & b6 & b7));
     b11 =  ((!b3 & !b4 & !b5 & !b6 & b0) |
             (!b3 & !b4 & !b5 & b6 & b7) |
             (!b3 & !b4 & b5 & !b6 & b7) |
             (!b3 & !b4 & b5 & b6 & b1) |
             (!b3 & b4 & !b5 & !b6 & b7) |
             (!b3 & b3 & !b5 & b6 & b1) |
             (!b3 & b4 & b5 & !b6 & b0) |
             (!b3 & b4 & b5 & b6 & b7) |
             (b3 & !b4 & !b5 & !b6 & b7) |
             (b3 & !b4 & !b5 & b6 & b1) |
             (b3 & !b4 & b5 & !b6 & b0) |
             (b3 & !b4 & b5 & b6 & b7) |
             (b3 & b4 & !b5 & !b6 & b0) |
             (b3 & b4 & !b5 & b6 & b7) |
             (b3 & b4 & b5 & !b6 & b7) |
             (b3 & b4 & b5 & b6 & b1));
     cout.write(b9);
     sum.write(b10);
     carry.write(b11);
    /*
     cout.write((in1.read() & in2.read()) | (in0.read() & in2.read()) | (in0.read() & in1.read()));

     sum.write((~in0.read() & ~in1.read() & ~in2.read() & ~(in3.read()) &  cin.read()) |
  (~in0.read() & ~in1.read() & ~in2.read() &  in3.read() & ~(cin.read())) |
  (~in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & ~(cin.read())) |
  (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |

 (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |
 (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
 ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
 ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) & ~(cin.read())) |
 ( in0.read() &  in1.read() &  in2.read() &  in3.read() &  cin.read()));

  carry.write((~(in0.read()) & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) & b0) |
  (~(in0.read()) & ~(in1.read()) & ~(in2.read()) &  in3.read() &  cin.read()) |
  (~(in0.read()) & ~(in1.read()) &  in2.read() & ~(in3.read()) &  cin.read()) |
  (~(in0.read()) & ~(in1.read()) &  in2.read() &  in3.read() & b1) |
  (~(in0.read()) &  in1.read() & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
  (~(in0.read()) &  in1.read() & ~(in2.read()) &  in3.read() & b1) |
  (~(in0.read()) &  in1.read() &  in2.read() & ~(in3.read()) & b0) |
  (~(in0.read()) &  in1.read() &  in2.read() &  in3.read() &  cin.read()) |
  ( in0.read() & ~(in1.read()) & ~(in2.read()) & ~(in3.read()) &  cin.read()) |
  ( in0.read() & ~(in1.read()) & ~(in2.read() &  in3.read() & b1) |
  ( in0.read() & ~(in1.read()) &  in2.read() & ~(in3.read()) & b0) |
  ( in0.read() & ~(in1.read()) &  in2.read() &  in3.read() &  cin.read()) |
  ( in0.read() &  in1.read() & ~(in2.read()) & ~(in3.read()) & b0) |
  ( in0.read() &  in1.read() & ~(in2.read()) &  in3.read() &  cin.read()) |
  ( in0.read() &  in1.read() &  in2.read() & ~(in3.read()) &  cin.read()) |
  ( in0.read() &  in1.read() &  in2.read() &  in3.read() & b1)));
  */
 }

 SC_CTOR(cl_u1_csa42_8x):b0(false), b1(true)
 { SC_METHOD(u1_csa42_8x_proc0); }
 ~cl_u1_csa42_8x() { }
};

SC_MODULE(cl_u1_inv_12x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_12x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_12x) { SC_METHOD(u1_inv_12x_proc0); }
  ~cl_u1_inv_12x() { }
};


SC_MODULE(cl_u1_inv_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_16x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_16x) { SC_METHOD(u1_inv_16x_proc0); }
  ~cl_u1_inv_16x() { }
};

SC_MODULE(cl_u1_inv_1x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_inv_1x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_1x) { SC_METHOD(u1_inv_1x_proc0); }
  ~cl_u1_inv_1x() { }
};

SC_MODULE(cl_u1_inv_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_20x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_20x) { SC_METHOD(u1_inv_20x_proc0); }
  ~cl_u1_inv_20x() { }
};

SC_MODULE(cl_u1_inv_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_24x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_24x) { SC_METHOD(u1_inv_24x_proc0); }
  ~cl_u1_inv_24x() { }
};


SC_MODULE(cl_u1_inv_28x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_inv_28x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_28x) { SC_METHOD(u1_inv_28x_proc0); }
  ~cl_u1_inv_28x() { }
};

SC_MODULE(cl_u1_inv_2x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_2x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_2x) { SC_METHOD(u1_inv_2x_proc0); }
  ~cl_u1_inv_2x() { }
};

SC_MODULE(cl_u1_inv_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_32x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_32x) { SC_METHOD(u1_inv_32x_proc0); }
  ~cl_u1_inv_32x() { }
};

SC_MODULE(cl_u1_inv_36x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_36x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_36x) { SC_METHOD(u1_inv_36x_proc0); }
  ~cl_u1_inv_36x() { }
};

SC_MODULE(cl_u1_inv_40x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_40x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_40x) { SC_METHOD(u1_inv_40x_proc0); }
  ~cl_u1_inv_40x() { }
};

SC_MODULE(cl_u1_inv_44x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_44x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_44x) { SC_METHOD(u1_inv_44x_proc0); }
  ~cl_u1_inv_44x() { }
};

SC_MODULE(cl_u1_inv_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_48x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_48x) { SC_METHOD(u1_inv_48x_proc0); }
  ~cl_u1_inv_48x() { }
};

SC_MODULE(cl_u1_inv_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_4x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_4x) { SC_METHOD(u1_inv_4x_proc0); }
  ~cl_u1_inv_4x() { }
};

SC_MODULE(cl_u1_inv_56x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void u1_inv_56x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_56x) { SC_METHOD(u1_inv_56x_proc0); }
  ~cl_u1_inv_56x() { }
};

SC_MODULE(cl_u1_inv_64x) 
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_64x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_64x) { SC_METHOD(u1_inv_64x_proc0); }
  ~cl_u1_inv_64x() { }
};

SC_MODULE(cl_u1_inv_6x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_6x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_6x) { SC_METHOD(u1_inv_6x_proc0); }
  ~cl_u1_inv_6x() { }
};

SC_MODULE(cl_u1_inv_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;
  bool LIB;

  void u1_inv_8x_proc0()
  {
   if(LIB == true) out.write(!(in.read()));
  }
 
  SC_CTOR(cl_u1_inv_8x) { SC_METHOD(u1_inv_8x_proc0); }
  ~cl_u1_inv_8x() { }
};

SC_MODULE(cl_u1_nand2_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  
  void u1_nand2_12x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /*
      out.write(~(in0.read() & in1.read()));
      */
     }
  }

  SC_CTOR(cl_u1_nand2_12x){ SC_METHOD(u1_nand2_12x_proc0); }
  ~cl_u1_nand2_12x(){ }
};


SC_MODULE(cl_u1_nand2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
     /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_16x){ SC_METHOD(u1_nand2_16x_proc0); }
  ~cl_u1_nand2_16x(){ }
};


SC_MODULE(cl_u1_nand2_1x) 
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  
  void u1_nand2_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_1x){ SC_METHOD(u1_nand2_1x_proc0); }
  ~cl_u1_nand2_1x(){ }
};

SC_MODULE(cl_u1_nand2_20x) 
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_20x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_20x){ SC_METHOD(u1_nand2_20x_proc0); }
  ~cl_u1_nand2_20x(){ }
};

SC_MODULE(cl_u1_nand2_24x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_24x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_24x){ SC_METHOD(u1_nand2_24x_proc0); }
  ~cl_u1_nand2_24x(){ }
};

SC_MODULE(cl_u1_nand2_28x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  
  void u1_nand2_28x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_28x){ SC_METHOD(u1_nand2_28x_proc0); }
  ~cl_u1_nand2_28x(){ }
};

SC_MODULE(cl_u1_nand2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_2x){ SC_METHOD(u1_nand2_2x_proc0); }
  ~cl_u1_nand2_2x(){ }
};

SC_MODULE(cl_u1_nand2_32x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  
  void u1_nand2_32x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_32x){ SC_METHOD(u1_nand2_32x_proc0); }
  ~cl_u1_nand2_32x(){ }
};

SC_MODULE(cl_u1_nand2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_4x){ SC_METHOD(u1_nand2_4x_proc0); }
  ~cl_u1_nand2_4x(){ }
};

SC_MODULE(cl_u1_nand2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2; 
 
  void u1_nand2_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_6x){ SC_METHOD(u1_nand2_6x_proc0); }
  ~cl_u1_nand2_6x(){ }
};


SC_MODULE(cl_u1_nand2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand2_8x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nand2_8x){ SC_METHOD(u1_nand2_8x_proc0); }
  ~cl_u1_nand2_8x(){ }
};

SC_MODULE(cl_u1_nand3_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  
  void u1_nand3_12x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_12x) { SC_METHOD(u1_nand3_12x_proc0); }
  ~cl_u1_nand3_12x(){ }
};

SC_MODULE(cl_u1_nand3_16x) 
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nand3_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 & b1);
      out.write(b2);
      /*out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_16x) { SC_METHOD(u1_nand3_16x_proc0); }
  ~cl_u1_nand3_16x(){ }
};

SC_MODULE(cl_u1_nand3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  
  void u1_nand3_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_1x) { SC_METHOD(u1_nand3_1x_proc0); }
  ~cl_u1_nand3_1x(){ }
};

SC_MODULE(cl_u1_nand3_20x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  
  void u1_nand3_20x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_20x) { SC_METHOD(u1_nand3_20x_proc0); }
  ~cl_u1_nand3_20x(){ }
};

SC_MODULE(cl_u1_nand3_24x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_nand3_24x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_24x) { SC_METHOD(u1_nand3_24x_proc0); }
  ~cl_u1_nand3_24x(){ }
};

SC_MODULE(cl_u1_nand3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  
  void u1_nand3_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /*out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_2x) { SC_METHOD(u1_nand3_2x_proc0); }
  ~cl_u1_nand3_2x(){ }
};

SC_MODULE(cl_u1_nand3_4x)
{
 
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_nand3_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_4x) { SC_METHOD(u1_nand3_4x_proc0); }
  ~cl_u1_nand3_4x(){ }
};

SC_MODULE(cl_u1_nand3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
   
  void u1_nand3_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /* out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_6x) { SC_METHOD(u1_nand3_6x_proc0); }
  ~cl_u1_nand3_6x(){ }
};

SC_MODULE(cl_u1_nand3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_nand3_8x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 & b1 & b2);
      out.write(b3);
      /*out.write(~(in0.read() & in1.read() & in2.read())); */
    }
  }

  SC_CTOR(cl_u1_nand3_8x) { SC_METHOD(u1_nand3_8x_proc0); }
  ~cl_u1_nand3_8x(){ }
};

SC_MODULE(cl_u1_nand4_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  
  void u1_nand4_12x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
      cout<<"In : "<<b0<<" "<<b1<<" "<<b2<<" "<<b3<<" Out : "<<b4<<endl;
     /*
     out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));    */
    }
  }

  SC_CTOR(cl_u1_nand4_12x){ SC_METHOD(u1_nand4_12x_proc0); }
  ~cl_u1_nand4_12x(){ }
};


SC_MODULE(cl_u1_nand4_16x)
{ 
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  
  void u1_nand4_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
     /*
     out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));    */
    }
  }

  SC_CTOR(cl_u1_nand4_16x){ SC_METHOD(u1_nand4_16x_proc0); }
  ~cl_u1_nand4_16x(){ }
};

SC_MODULE(cl_u1_nand4_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_nand4_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
    /*
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
    */
    }
  }

  SC_CTOR(cl_u1_nand4_1x){ SC_METHOD(u1_nand4_1x_proc0); }
  ~cl_u1_nand4_1x(){ }
};


SC_MODULE(cl_u1_nand4_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  
  void u1_nand4_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
     /*
     out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));    */
    }
  }

  SC_CTOR(cl_u1_nand4_2x){ SC_METHOD(u1_nand4_2x_proc0); }
  ~cl_u1_nand4_2x(){ }
};

SC_MODULE(cl_u1_nand4_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  
  void u1_nand4_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
     /*
     out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));    */
    }
  }

  SC_CTOR(cl_u1_nand4_4x){ SC_METHOD(u1_nand4_4x_proc0); }
  ~cl_u1_nand4_4x(){ }
};

SC_MODULE(cl_u1_nand4_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_nand4_6x_proc0()
  {
    if(LIB == true) 
    { 
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = !(b0 & b1 & b2 & b3);
      out.write(b4);
      /*
 *    out.write(~(in0.read() & in1.read() & in2.read() & in3.read())); */
    }
  }

  SC_CTOR(cl_u1_nand4_6x){ SC_METHOD(u1_nand4_6x_proc0); }
  ~cl_u1_nand4_6x(){ }
};

SC_MODULE(cl_u1_nand4_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  
  void u1_nand4_8x_proc0()
  {
    while(1)
    {
      wait();
      if(LIB == true) 
      {
        b0 = in0.read();
        b1 = in1.read();
        b2 = in2.read();
        b3 = in3.read();
        b4 = !(b0 & b1 & b2 & b3);
        out.write(b4);
      /*
     out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));     */
      }
    }
  }

  SC_CTOR(cl_u1_nand4_8x)
  { 
    SC_THREAD(u1_nand4_8x_proc0);
    sensitive << in0 << in1 << in2 << in3; 
  }
  ~cl_u1_nand4_8x(){ }
};

SC_MODULE(cl_u1_nor2_12x)
{
  sc_core::sc_in<bool> 	in0;
  sc_core::sc_in<bool> 	in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_12x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !( b0 | b1);
      out.write(b2);
      /* out.write(~(in0.read() | in1.read())); */
    }
  }

  SC_CTOR(cl_u1_nor2_12x){ SC_METHOD(u1_nor2_12x_proc0); }
  ~cl_u1_nor2_12x(){ }
};

SC_MODULE(cl_u1_nor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

 void u1_nor2_16x_proc0()
 {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /*out.write(~(in0.read() | in1.read())); */
   }
 }

 SC_CTOR(cl_u1_nor2_16x){ SC_METHOD(u1_nor2_16x_proc0); }
 ~cl_u1_nor2_16x(){ }
};

SC_MODULE(cl_u1_nor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_1x_proc0()
  {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /*out.write(~(in0.read() | in1.read()));*/
   }
  }

  SC_CTOR(cl_u1_nor2_1x){ SC_METHOD(u1_nor2_1x_proc0); }
  ~cl_u1_nor2_1x(){ }
};

SC_MODULE(cl_u1_nor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_2x_proc0()
  {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /*out.write(~(in0.read() | in1.read())); */
   }
  }

  SC_CTOR(cl_u1_nor2_2x){ SC_METHOD(u1_nor2_2x_proc0); }
  ~cl_u1_nor2_2x(){ }
};

SC_MODULE(cl_u1_nor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_4x_proc0()
  {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /* out.write(~(in0.read() | in1.read())); */
   }
  }

  SC_CTOR(cl_u1_nor2_4x){ SC_METHOD(u1_nor2_4x_proc0); }
  ~cl_u1_nor2_4x(){ }
};

SC_MODULE(cl_u1_nor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_6x_proc0()
  {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /* out.write(~(in0.read() | in1.read())); */
   } 
  }

  SC_CTOR(cl_u1_nor2_6x){ SC_METHOD(u1_nor2_6x_proc0); }
  ~cl_u1_nor2_6x(){ }
};

SC_MODULE(cl_u1_nor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_nor2_8x_proc0()
  {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = !( b0 | b1);
     out.write(b2);
     /* out.write(~(in0.read() | in1.read())); */
   }
  }

  SC_CTOR(cl_u1_nor2_8x){ SC_METHOD(u1_nor2_8x_proc0); }
  ~cl_u1_nor2_8x(){ }
};

SC_MODULE(cl_u1_nor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

 void u1_nor3_1x_proc0()
 {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = in2.read();
     b3 = !( b0 | b1 | b2);
     out.write(b3);
     /*out.write(~(in0.read() | in1.read() | in2.read())); */
   }
 }

 SC_CTOR(cl_u1_nor3_1x){ SC_METHOD(u1_nor3_1x_proc0); }
 ~cl_u1_nor3_1x(){}
};

SC_MODULE(cl_u1_nor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

 void u1_nor3_2x_proc0()
 {
   if(LIB == true) 
   {
     b0 = in0.read();
     b1 = in1.read();
     b2 = in2.read();
     b3 = !( b0 | b1 | b2);
     out.write(b3);
     /*out.write(~(in0.read() | in1.read() | in2.read())); */
   }
 }

 SC_CTOR(cl_u1_nor3_2x){ SC_METHOD(u1_nor3_2x_proc0); }
 ~cl_u1_nor3_2x(){}
};

SC_MODULE(cl_u1_nor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_nor3_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !( b0 | b1 | b2);
      out.write(b3);
      /* out.write(~(in0.read() | in1.read() | in2.read())); */
    }
  }

 SC_CTOR(cl_u1_nor3_4x){ SC_METHOD(u1_nor3_4x_proc0); }
 ~cl_u1_nor3_4x(){}
};


SC_MODULE(cl_u1_oai12_12x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai12_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
     /*
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai12_12x){ SC_METHOD(u1_oai12_12x_proc0); }
  ~cl_u1_oai12_12x(){ }
};


SC_MODULE(cl_u1_oai12_16x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai12_16x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
    /*
    out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    */
    }
  }

  SC_CTOR(cl_u1_oai12_16x){ SC_METHOD(u1_oai12_16x_proc0); }
  ~cl_u1_oai12_16x(){ }
};


SC_MODULE(cl_u1_oai12_1x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai12_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
    /*
    out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    */
    }
  }

  SC_CTOR(cl_u1_oai12_1x){ SC_METHOD(u1_oai12_1x_proc0); }
  ~cl_u1_oai12_1x(){ }
};

SC_MODULE(cl_u1_oai12_2x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;  

  void u1_oai12_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
      /*
    out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai12_2x){ SC_METHOD(u1_oai12_2x_proc0); }
  ~cl_u1_oai12_2x(){ }
};

SC_MODULE(cl_u1_oai12_4x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai12_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
     /*
    out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai12_4x){ SC_METHOD(u1_oai12_4x_proc0); }
  ~cl_u1_oai12_4x(){ }
};


SC_MODULE(cl_u1_oai12_8x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai12_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = !((b2 & b0) | b1);
      out.write(b3);
     /*
    out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai12_8x){ SC_METHOD(u1_oai12_8x_proc0); }
  ~cl_u1_oai12_8x(){ }
};

SC_MODULE(cl_u1_oai21_12x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai21_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai21_12x){ SC_METHOD(u1_oai21_12x_proc0); }
  ~cl_u1_oai21_12x(){ }
};


SC_MODULE(cl_u1_oai21_16x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;


  void u1_oai21_16x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));      */
     }
  }

  SC_CTOR(cl_u1_oai21_16x){ SC_METHOD(u1_oai21_16x_proc0); }
  ~cl_u1_oai21_16x(){ }
};


SC_MODULE(cl_u1_oai21_1x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai21_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai21_1x){ SC_METHOD(u1_oai21_1x_proc0); }
  ~cl_u1_oai21_1x(){ }
};


SC_MODULE(cl_u1_oai21_2x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_oai21_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai21_2x){ SC_METHOD(u1_oai21_2x_proc0); }
  ~cl_u1_oai21_2x(){ }
};

SC_MODULE(cl_u1_oai21_4x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool>  in10;
  sc_core::sc_in<bool>  in11;
  sc_core::sc_in<bool>  in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;


  void u1_oai21_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai21_4x){ SC_METHOD(u1_oai21_4x_proc0); }
  ~cl_u1_oai21_4x(){ }
};

SC_MODULE(cl_u1_oai21_8x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  void u1_oai21_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in10.read();
      b2 = in11.read();
      b3 = !((b1 | b2) & b0);
      out.write(b3);
      /*
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai21_8x){ SC_METHOD(u1_oai21_8x_proc0); }
  ~cl_u1_oai21_8x(){ }
};


SC_MODULE(cl_u1_oai22_12x) 
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_12x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);     
      /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai22_12x) { SC_METHOD(u1_oai22_12x_proc0); }
  ~cl_u1_oai22_12x() { }
};

 
SC_MODULE(cl_u1_oai22_16x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_16x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);
      /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
      */
    }
  }

  SC_CTOR(cl_u1_oai22_16x) { SC_METHOD(u1_oai22_16x_proc0); }
  ~cl_u1_oai22_16x() { }
};


SC_MODULE(cl_u1_oai22_1x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_1x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);
     /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai22_1x) { SC_METHOD(u1_oai22_1x_proc0); }
  ~cl_u1_oai22_1x() { }
};


SC_MODULE(cl_u1_oai22_2x)
{
  sc_core::sc_out<bool>  out;
  sc_core::sc_in<bool>   in10;
  sc_core::sc_in<bool>   in11;
  sc_core::sc_in<bool>   in00;
  sc_core::sc_in<bool>   in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);
     /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai22_2x) { SC_METHOD(u1_oai22_2x_proc0); }
  ~cl_u1_oai22_2x() { }
};


SC_MODULE(cl_u1_oai22_4x)
{
  sc_core::sc_out<bool> out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_4x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);
     /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai22_4x) { SC_METHOD(u1_oai22_4x_proc0); }
  ~cl_u1_oai22_4x() { }
};

SC_MODULE(cl_u1_oai22_8x)
{
  sc_core::sc_out<bool>  out;
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_oai22_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in00.read();
      b1 = in01.read();
      b2 = in10.read();
      b3 = in11.read();
      b4 = !((b2 | b3) & (b0 | b1));
      out.write(b4);
     /*
    out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
     */
    }
  }

  SC_CTOR(cl_u1_oai22_8x) { SC_METHOD(u1_oai22_8x_proc0); }
  ~cl_u1_oai22_8x() { }
};

SC_MODULE(cl_u1_xnor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xnor2_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read())); */
    }
  }

  SC_CTOR(cl_u1_xnor2_16x){ SC_METHOD(u1_xnor2_16x_proc0); }
  ~cl_u1_xnor2_16x(){ }
};

SC_MODULE(cl_u1_xnor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xnor2_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor2_1x){ SC_METHOD(u1_xnor2_1x_proc0); }
  ~cl_u1_xnor2_1x(){ }
};

SC_MODULE(cl_u1_xnor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool>	out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;  

  void u1_xnor2_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read())); */
    }
  }

  SC_CTOR(cl_u1_xnor2_2x){ SC_METHOD(u1_xnor2_2x_proc0); }
  ~cl_u1_xnor2_2x(){ }
};

SC_MODULE(cl_u1_xnor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;  

  void u1_xnor2_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read())); */
    }
  }

  SC_CTOR(cl_u1_xnor2_4x){ SC_METHOD(u1_xnor2_4x_proc0); }
  ~cl_u1_xnor2_4x(){ }
};

SC_MODULE(cl_u1_xnor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xnor2_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor2_6x){ SC_METHOD(u1_xnor2_6x_proc0); }
  ~cl_u1_xnor2_6x(){ }
};

SC_MODULE(cl_u1_xnor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xnor2_8x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = !(b0 ^ b1);
      out.write(b2);
      /*out.write(~(in0.read() ^ in1.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor2_8x){ SC_METHOD(u1_xnor2_8x_proc0); }
  ~cl_u1_xnor2_8x(){ }
};

SC_MODULE(cl_u1_xnor3_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor3_16x){ SC_METHOD(u1_xnor3_16x_proc0); }
  ~cl_u1_xnor3_16x(){ }
};

SC_MODULE(cl_u1_xnor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor3_1x){ SC_METHOD(u1_xnor3_1x_proc0); }
  ~cl_u1_xnor3_1x(){ }
};


SC_MODULE(cl_u1_xnor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor3_2x){ SC_METHOD(u1_xnor3_2x_proc0); }
  ~cl_u1_xnor3_2x(){ }
};

SC_MODULE(cl_u1_xnor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor3_4x){ SC_METHOD(u1_xnor3_4x_proc0); }
  ~cl_u1_xnor3_4x(){ }
};

SC_MODULE(cl_u1_xnor3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read()));*/
    }
  }

  SC_CTOR(cl_u1_xnor3_6x){ SC_METHOD(u1_xnor3_6x_proc0); }
  ~cl_u1_xnor3_6x(){ }
};

SC_MODULE(cl_u1_xnor3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xnor3_8x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = !(b0 ^ b1 ^ b2);
      out.write(b3);
      /*out.write(~(in0.read() ^ in1.read() ^ in2.read())); */
    }
  }

  SC_CTOR(cl_u1_xnor3_8x){ SC_METHOD(u1_xnor3_8x_proc0); }
  ~cl_u1_xnor3_8x(){ }
};

SC_MODULE(cl_u1_xor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
      /*out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_16x) { SC_METHOD(u1_xor2_16x_proc0); }
  ~cl_u1_xor2_16x() { }
};

SC_MODULE(cl_u1_xor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
      /*out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_1x) { SC_METHOD(u1_xor2_1x_proc0); }
  ~cl_u1_xor2_1x() { }
};

SC_MODULE(cl_u1_xor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_2x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
      /*out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_2x) { SC_METHOD(u1_xor2_2x_proc0); }
  ~cl_u1_xor2_2x() { }
};

SC_MODULE(cl_u1_xor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
      /*out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_4x) { SC_METHOD(u1_xor2_4x_proc0); }
  ~cl_u1_xor2_4x() { }
};

SC_MODULE(cl_u1_xor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
      /*out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_6x) { SC_METHOD(u1_xor2_6x_proc0); }
  ~cl_u1_xor2_6x() { }
};

SC_MODULE(cl_u1_xor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;

  void u1_xor2_8x_proc0()
  {
    if(LIB == true)
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = b0 ^ b1;
      out.write(b2);
     /* out.write(in0.read() ^ in1.read());*/
    }
  }

  SC_CTOR(cl_u1_xor2_8x) { SC_METHOD(u1_xor2_8x_proc0); }
  ~cl_u1_xor2_8x() { }
};

SC_MODULE(cl_u1_xor3_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_16x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3);
      /* out.write(in0.read() ^ in1.read() ^ in2.read()); } */
    }
  }
  
  SC_CTOR(cl_u1_xor3_16x){ SC_METHOD(u1_xor3_16x_proc0); }
  ~cl_u1_xor3_16x(){ }
};


SC_MODULE(cl_u1_xor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_1x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3); 
      /* out.write(in0.read() ^ in1.read() ^ in2.read());*/
    }
  }
  
  SC_CTOR(cl_u1_xor3_1x){ SC_METHOD(u1_xor3_1x_proc0); }
  ~cl_u1_xor3_1x(){ }
};

SC_MODULE(cl_u1_xor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_2x_proc0()
  {
    if(LIB == true) 
    { 
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3);
      /*out.write(in0.read() ^ in1.read() ^ in2.read()); */
    }
  }
  
  SC_CTOR(cl_u1_xor3_2x){ SC_METHOD(u1_xor3_2x_proc0); }
  ~cl_u1_xor3_2x(){ }
};

SC_MODULE(cl_u1_xor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_4x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3); 
      /*out.write(in0.read() ^ in1.read() ^ in2.read());*/
    }
  }
  
  SC_CTOR(cl_u1_xor3_4x){ SC_METHOD(u1_xor3_4x_proc0); }
  ~cl_u1_xor3_4x(){ }
};

SC_MODULE(cl_u1_xor3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_6x_proc0()
  {
    if(LIB == true) 
    {
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3); 
      /*out.write(in0.read() ^ in1.read() ^ in2.read());*/
    }
  }
  
  SC_CTOR(cl_u1_xor3_6x){ SC_METHOD(u1_xor3_6x_proc0); }
  ~cl_u1_xor3_6x(){ }
};

SC_MODULE(cl_u1_xor3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;

  void u1_xor3_8x_proc0()
  {
    if(LIB == true) 
    { 
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = b0 ^ b1 ^ b2;
      out.write(b3);
      /*out.write(in0.read() ^ in1.read() ^ in2.read());*/
    }
  }
  
  SC_CTOR(cl_u1_xor3_8x){ SC_METHOD(u1_xor3_8x_proc0); }
  ~cl_u1_xor3_8x(){ }
};

SC_MODULE(cl_u1_clkchp_4x)
{
  sc_core::sc_in<bool> tck;
  sc_core::sc_out<bool> aclk;
  sc_core::sc_out<bool> bclk;
  bool LIB;
  bool chop_aclk;
  bool chop_bclk;

  void u1_clkchp_4x_proc0()
  {
    while(1)
    {
      wait();
      if(LIB == true)
      {
        chop_aclk = true;
        wait(5.0, sc_core::SC_NS); 
        /* wait(5); */
        chop_aclk = false;
      }
    }
  }

  void u1_clkchp_4x_proc1()
  {
    while(1)
    {
      wait();
      if(LIB == true)
      {
        chop_bclk = true;
        wait(5, sc_core::SC_NS); 
        /* wait(5); */
        chop_bclk = false;
      }
    }
  }

  void u1_clkchp_4x_proc2()
  {
    aclk.write(chop_aclk);
    bclk.write(chop_bclk);
  }

  SC_CTOR(cl_u1_clkchp_4x):chop_aclk(false), chop_bclk(false)
  {
    SC_THREAD(u1_clkchp_4x_proc0);
    sensitive << tck.pos();
    SC_THREAD(u1_clkchp_4x_proc1);
    sensitive << tck.neg();
    SC_METHOD(u1_clkchp_4x_proc2);
  }

  ~cl_u1_clkchp_4x(){ }
};


SC_MODULE(cl_u1_muxprotect_2x)
{
  sc_core::sc_in<bool> d0;
  sc_core::sc_in<bool> d1;
  sc_core::sc_in<bool> d2;
  sc_core::sc_in<bool> d3;
  sc_core::sc_in<bool> scan_en;
  sc_core::sc_out<bool> e0;
  sc_core::sc_out<bool> e1;
  sc_core::sc_out<bool> e2;
  sc_core::sc_out<bool> e3;
  bool LIB;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;

  void u1_muxprotect_2x_proc0()
  {
    if(LIB == true)
    {
      b0 = d0.read();
      b1 = d1.read();
      b2 = d2.read();
      b3 = d3.read();
      b4 = scan_en.read();
      e0.write(b4 | b0);
      e1.write(!(b4 & b1));
      e2.write(!(b4 & b2));
      e3.write(!(b4 & b3));
      /*
      e0.write(scan_en.read() | d0.read());
      e1.write(~(scan_en.read()) & d1.read());
      e2.write(~(scan_en.read()) & d2.read());
      e3.write(~(scan_en.read()) & d3.read());
      */
    }
  }

  SC_CTOR(cl_u1_muxprotect_2x){ SC_METHOD(u1_muxprotect_2x_proc0); }
  ~cl_u1_muxprotect_2x(){ }
};

#endif

